package jp.cssj.sakae.gc.text.layout.control;

import jp.cssj.sakae.gc.font.FontListMetrics;

public class LineBreak extends Control {
	private final FontListMetrics flm;

	public LineBreak(FontListMetrics flm) {
		this.flm = flm;
	}

	public char getControlChar() {
		return '\n';
	}

	public double getAdvance() {
		return 0;
	}

	public double getAscent() {
		return this.flm.getMaxAscent();
	}

	public double getDescent() {
		return this.flm.getMaxDescent();
	}

	public String toString() {
		return "\\n";
	}

}
