package jp.cssj.sakae.gc.text.hyphenation.impl;

import jp.cssj.sakae.gc.text.FilterGlyphHandler;
import jp.cssj.sakae.gc.text.hyphenation.Hyphenation;

public class DefaultHyphenation implements Hyphenation {
	private final BindingRule bindingRule;

	public DefaultHyphenation(BindingRule bindingRule) {
		this.bindingRule = bindingRule;
	}

	public FilterGlyphHandler getTextUnitizer() {
		return new DefaultTextUnitizer(this.bindingRule);
	}

	public boolean canSeparate(char c1, char c2) {
		return this.bindingRule.canSeparate(c1, c2);
	}
}
