package jp.cssj.sakae.gc.text.hyphenation;

import jp.cssj.sakae.gc.text.FilterGlyphHandler;

/**
 * 言語ごとのハイフネーションです。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko</a>
 * @version $Id: Hyphenation.java 667 2011-09-06 14:14:16Z miyabe $
 */
public interface Hyphenation {
	/**
	 * 禁則処理のためテキストを分割できないまとまりに分解するオブジェクトを返します。
	 * 
	 * @return テキストを分解するオブジェクト。
	 */
	public FilterGlyphHandler getTextUnitizer();

	/**
	 * 両あわせ処理のために文字を分割可能であればtrueを返します。
	 * 
	 * @param c1
	 *            前の文字。
	 * @param c2
	 *            後の文字。
	 * @return 分割可能であればtrue。
	 */
	public boolean canSeparate(char c1, char c2);
}
