package jp.cssj.sakae.gc.text;

import jp.cssj.sakae.gc.font.FontMetrics;
import jp.cssj.sakae.gc.font.FontStyle;

/**
 * 描画可能なテキストです。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko</a>
 * @version $Id: Text.java 667 2011-09-06 14:14:16Z miyabe $
 */
public interface Text extends Element {
	public FontStyle getFontStyle();

	public FontMetrics getFontMetrics();

	public double getAscent();

	public double getDescent();

	public char[] getChars();

	public int getCOff();

	public int getCLen();

	public int[] getGIDs();

	public byte[] getCLens();

	public int getGOff();

	public int getGLen();

	public double getLetterSpacing();

	public void toGlyphs(GlyphHandler gh);

	public double[] getXAdvances(boolean make);
}
