package jp.cssj.sakae.gc.text;

import jp.cssj.sakae.gc.font.FontMetrics;
import jp.cssj.sakae.gc.font.FontStyle;

/**
 * グリフ単位で分解されたテキストの送り先です。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko</a>
 * @version $Id: GlyphHandler.java 667 2011-09-06 14:14:16Z miyabe $
 */
public interface GlyphHandler {
	/**
	 * テキストランを開始します。
	 * 
	 * @param fontStyle
	 * @param fontMetrics
	 */
	public void startTextRun(FontStyle fontStyle, FontMetrics fontMetrics);

	/**
	 * テキストランを終わります。
	 */
	public void endTextRun();

	/**
	 * グリフを送ります。
	 * 
	 * @param glyph
	 */
	public void glyph(char[] ch, int coff, byte clen, int gid);

	/**
	 * 込め物を送ります。
	 * 
	 * @param quad
	 */
	public void quad(Quad quad);

	public void flush();
}
