package jp.cssj.sakae.gc.text;

import jp.cssj.sakae.gc.font.FontStyle;

/**
 * 文字列からグリフに変換するために文字列を処理します。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko</a>
 * @version $Id: CharacterHandler.java 667 2011-09-06 14:14:16Z miyabe $
 */
public interface CharacterHandler {
	/**
	 * カレントのスタイルを設定します。
	 * 
	 * @param fontStyle
	 */
	public void fontStyle(FontStyle fontStyle);

	/**
	 * 処理する文字列を送ります。
	 * 
	 * @param ch
	 * @param off
	 * @param len
	 */
	public void characters(char[] ch, int off, int len);

	/**
	 * 込め物を入れます。
	 * 
	 * @param quad
	 */
	public void quad(Quad quad);

	/**
	 * 段落を終わります。
	 * 
	 * <b>このメソッドはwordBrak()を呼びます。</b>
	 */
	public void flush();
}
