package jp.cssj.sakae.gc.text;

/**
 * 描画可能なテキストです。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko</a>
 * @version $Id: AbstractText.java 667 2011-09-06 14:14:16Z miyabe $
 */
public abstract class AbstractText implements Text {
	public short getElementType() {
		return Element.TEXT;
	}

	public void toGlyphs(GlyphHandler gh) {
		int glen = this.getGLen();
		gh.startTextRun(this.getFontStyle(), this.getFontMetrics());
		int goff = this.getGOff();
		byte[] clens = this.getCLens();
		char[] ch = this.getChars();
		int coff = this.getCOff();
		int[] gids = this.getGIDs();
		for (int i = 0; i < glen; ++i) {
			int ii = i + goff;
			byte clen = clens[ii];
			gh.glyph(ch, coff, clen, gids[ii]);
			coff += clen;
		}
		gh.endTextRun();
	}

	/**
	 * テキストを文字列として返します。
	 */
	public String toString() {
		StringBuffer buff = new StringBuffer();
		buff.append("[Text]");
		buff.append(this.getChars(), this.getCOff(), this.getCLen());
		buff.append("[");
		int goff = this.getGOff();
		int glen = this.getGLen();
		int[] gids = this.getGIDs();
		for (int i = 0; i < glen; ++i) {
			int gid = gids[i + goff];
			if (i > 0) {
				buff.append(',');
			}
			buff.append(Integer.toHexString(gid));
		}
		buff.append("]");
		buff.append("[/Text]");
		return buff.toString();
	}
}
