package jp.cssj.sakae.gc.paint;

import java.io.Serializable;

/**
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: CMYKColor.java 674 2011-09-11 09:05:26Z miyabe $
 */
public class CMYKColor implements Color, Serializable {
	private static final long serialVersionUID = 0L;
	public static final int C = 0, M = 1, Y = 2, K = 3;
		
	public static CMYKColor create(float cyan, float magenta, float yellow, float black) {
		return new CMYKColor(cyan, magenta, yellow, black);
	}

	private final float cyan, magenta, yellow, black;

	protected CMYKColor(float cyan, float magenta, float yellow, float black) {
		this.cyan = Math.min(1.0f, Math.max(0f, cyan));
		this.magenta = Math.min(1.0f, Math.max(0f, magenta));
		this.yellow = Math.min(1.0f, Math.max(0f, yellow));
		this.black = Math.min(1.0f, Math.max(0f, black));
	}
	
	public short getPaintType() {
		return COLOR;
	}

	public short getColorType() {
		return CMYK;
	}

	public float getComponent(int i) {
		switch (i) {
		case C:
			return this.cyan;
		case M:
			return this.magenta;
		case Y:
			return this.yellow;
		case K:
			return this.black;
		}
		throw new IllegalArgumentException();
	}

	public float getRed() {
		return Math.max(0, 1.0f - (this.cyan + this.black));
	}

	public float getGreen() {
		return Math.max(0, 1.0f - (this.magenta + this.black));
	}

	public float getBlue() {
		return Math.max(0, 1.0f - (this.yellow + this.black));
	}

	public boolean equals(Object o) {
		if (o instanceof CMYKColor) {
			CMYKColor color = (CMYKColor) o;
			return this.cyan == color.cyan && this.magenta == color.magenta
					&& this.yellow == color.yellow && this.black == color.black;
		}
		return false;
	}

	public String toString() {
		return "-cssj-cmyk(" + this.cyan + "," + this.magenta + ","
				+ this.yellow + "," + this.black + ")";
	}
}