package jp.cssj.sakae.gc;

import java.awt.Shape;
import java.awt.geom.AffineTransform;

import jp.cssj.sakae.gc.font.FontManager;
import jp.cssj.sakae.gc.image.Image;
import jp.cssj.sakae.gc.text.Text;

/**
 * グラフィックコンテキストです。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko </a>
 * @version $Id: GC.java 758 2011-11-13 14:05:46Z miyabe $
 */
public interface GC {
	public static final short LINE_JOIN_MITER = 0;

	public static final short LINE_JOIN_ROUND = 1;

	public static final short LINE_JOIN_BEVEL = 2;

	public static final short LINE_CAP_BUTT = 0;

	public static final short LINE_CAP_ROUND = 1;

	public static final short LINE_CAP_SQUARE = 2;

	public static final double[] STROKE_SOLID = new double[0];

	public FontManager getFontManager();

	public void begin() throws GraphicsException;

	public void resetState() throws GraphicsException;

	public void end() throws GraphicsException;

	public void setOpacity(float opacity) throws GraphicsException;

	public float getOpacity();

	// FIXME 互換性のためPaintのところObjectに
	public void setStrokePaint(Object paint) throws GraphicsException;

	// FIXME 互換性のためPaintのところObjectに
	public void setFillPaint(Object paint) throws GraphicsException;

	public void setLineWidth(double width) throws GraphicsException;

	public double getLineWidth();

	public void setLinePattern(double[] pattern) throws GraphicsException;

	public double[] getLinePattern();

	public void setLineJoin(short style) throws GraphicsException;

	public short getLineJoin();

	public void setLineCap(short style) throws GraphicsException;

	public short getLineCap();

	public void transform(AffineTransform at) throws GraphicsException;

	public AffineTransform getTransform();

	public void clip(Shape shape) throws GraphicsException;

	public Shape getClip();

	public void draw(Shape shape) throws GraphicsException;

	public void fill(Shape shape) throws GraphicsException;

	public void fillDraw(Shape shape) throws GraphicsException;

	public void drawImage(Image image) throws GraphicsException;

	public void drawText(Text text, double x, double y)
			throws GraphicsException;

	public GroupImageGC creatgeGroupImage(double width, double height)
			throws GraphicsException;
}