package jp.cssj.sakae.font;

import java.io.Serializable;

/**
 * TTFやシステムフォント等PDFフォントの元となるフォントです。
 * 
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko</a>
 * @version $Id: FontSource.java 689 2011-09-17 07:52:20Z miyabe $
 */
public interface FontSource extends Serializable {
	/**
	 * フォント名を返します。
	 * 
	 * @return
	 */
	public String getFontName();

	/**
	 * フォントの別名を列挙します。
	 * 
	 * @return
	 */
	public String[] getAliases();

	/**
	 * 描画方向を返します。
	 * 
	 * @return　FontStyle.DIRECTION_XX値。
	 */
	public byte getDirection();

	/**
	 * @return 斜体であればtrue。
	 */
	public boolean isItalic();

	/**
	 * @return フォントのウェイト。
	 */
	public short getWeight();

	/**
	 * 1em当たりのユニット数です。
	 */
	public static final double UNITS_PER_EM = 1000.0;

	/**
	 * 文字を表示可能であればtrueを返します。
	 * 
	 * @param c
	 * @return
	 */
	public boolean canDisplay(int c);

	/**
	 * @return バウンディングボックス。
	 */
	public BBox getBBox();

	/**
	 * ベースラインの上の高さを返します。
	 * 
	 * @return
	 */
	public short getAscent();

	/**
	 * 大文字の高さ(em)を返します。
	 * 
	 * @return
	 */
	public short getCapHeight();

	/**
	 * ベースラインより下の高さを返します。
	 * 
	 * @return
	 */
	public short getDescent();

	/**
	 * @return this.Returns the stemh.
	 */
	public short getStemH();

	/**
	 * @return this.Returns the stemv.
	 */
	public short getStemV();

	/**
	 * 小文字の高さ(ex)を返します。
	 * 
	 * @return
	 */
	public short getXHeight();

	/**
	 * 空白文字の幅を返します。
	 * 
	 * @return
	 */
	public short getSpaceAdvance();

	/**
	 * ドキュメント中のフォントを作成します。
	 * 
	 * @param name
	 * @param fontRef
	 * @return
	 */
	public Font createFont();
}
