package jp.cssj.sakae.font;

import java.io.IOException;
import java.io.Serializable;

import jp.cssj.sakae.gc.GC;
import jp.cssj.sakae.gc.GraphicsException;
import jp.cssj.sakae.gc.text.Text;

/**
 * @author <a href="mailto:tatsuhiko at miya dot be">MIYABE Tatsuhiko</a>
 * @version $Id: Font.java 689 2011-09-17 07:52:20Z miyabe $
 */
public interface Font extends Serializable {
	/**
	 * フォントソースを返します。
	 * 
	 * @return
	 */
	public FontSource getFontSource();

	/**
	 * 文字をグリフコードに変換します。
	 * 
	 * @param c
	 * @return
	 */
	public int toGID(int c);

	/**
	 * グリフの進行方向の進行幅を返します。
	 * 
	 * @param gid
	 * @return
	 */
	public short getAdvance(int gid);

	/**
	 * グリフの進行方向の横幅を返します。
	 * 
	 * @param gid
	 * @return
	 */
	public short getWidth(int gid);

	/**
	 * グリフのカーニングを返します。
	 * 
	 * @param sgid
	 * @param gid
	 * @return
	 */
	public short getKerning(int sgid, int gid);

	/**
	 * 合字を返します。 合字が存在しない場合は0を返します。
	 * 
	 * @param sgid
	 * @param gid
	 * @return
	 */
	public int getLigature(int sgid, int gid);

	/**
	 * ランをグラフィックコンテキストに出力します。
	 * 
	 * @param gc
	 * @param run
	 * @param letterSpacing
	 *            字間
	 * @return テキスト幅
	 * @throws IOException
	 */
	public void drawTo(GC gc, Text text) throws IOException, GraphicsException;
}
