//---------------------------------------------------------------------------
#ifndef ScriptH
#define ScriptH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <vcl\clipbrd.hpp>
//---------------------------------------------------------------------------
#include "Base.h"
#include "KCodeconv.h"
#include <Dialogs.hpp>


class KCopalConfig;
//---------------------------------------------------------------------------
class TFScript : public TFBase {
__published:	// IDE Ǘ̃R|[lg
  TRichEdit *REScript;
        TOpenDialog *OpenDialog;
  void __fastcall FormActivate(TObject *Sender);
  void __fastcall REScriptChange(TObject *Sender);
  void __fastcall REScriptMouseDown(TObject *Sender,
                                    TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall REScriptKeyUp(TObject *Sender, WORD &Key,
                                TShiftState Shift);
  void __fastcall REScriptMouseUp(TObject *Sender,
                                  TMouseButton Button, TShiftState Shift, int X, int Y);
private:	// [U[錾

  int Delimiter;//sR[h
  int Code;//R[h
  int FileDate;
  bool Modified;//ύXǂ
  AnsiString FileName;//t@C
  TSearchTypes SearchOption;
  KCopalConfig *CopalConfig;

public:		// [U[錾


  void SetCopalConfig(KCopalConfig *c) {
    CopalConfig = c;
  };

  AnsiString GetFileName(void) {
    return FileName;
  };

  //---------------------------------------------------------------------------
  void SetWindowFocus(void);
  AnsiString GetCaptionStr(void);

  //---------------------------------------------------------------------------
  // ҏW
  //---------------------------------------------------------------------------
  void Undo(void);
  bool CanUndo(void) {
    return REScript->Perform(EM_CANUNDO,0,0);
  };

  void SetReadOnly(bool b) {
    REScript->ReadOnly = b;
  };

  //---------------------------------------------------------------------------
  //֘A
  //---------------------------------------------------------------------------
  void Find(void);
  void FindNext(void);
  void FindPrev(void);
  void MakeCursorVisible(void);
  void __fastcall OnFind(TObject *Sender);

  //---------------------------------------------------------------------------
  // Nbv{[h
  //---------------------------------------------------------------------------
  void Cut(void);
  void Copy(void);
  void Paste(void);
  //---------------------------------------------------------------------------
  bool SaveQuery(void);
  void Save(void);
  void SaveAs(void);
  void Load(void);
  void New(void);
  //---------------------------------------------------------------------------
  AnsiString GetCaretString(void);
  AnsiString GetHelpKeyWord(void);
  void CheckFileDate(void);

  void LineJump(int line);//sWv
  bool ExecuteEditor(void);

  void SaveToTemporaryFile(AnsiString FileName);//XNvg̕ۑ
  void SaveToFile(AnsiString FileName);//XNvg̕ۑ
  void LoadFromFile(AnsiString FileName);//XNvgJ
  void Reload(void) {
    LoadFromFile(FileName);
  };

  void SetTabWidth(KCopalConfig *,int tabwidth);

  //---
  // R[h֘A
  //---
  int GetDelimiter(void) {
    return Delimiter;
  };
  int GetCode(void) {
    return Code;
  };
  void SetCode(int mode);

  __fastcall TFScript(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TFScript *FScript;
//---------------------------------------------------------------------------
#endif
