//---------------------------------------------------------------------------
// XNvg̎sʂ\tH[
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Main.h"
#include "Result.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "Base"
#pragma resource "*.dfm"
TFResult *FResult;
//---------------------------------------------------------------------------
__fastcall
TFResult::TFResult(TComponent* Owner)
    : TFBase(Owner) {
  //hbLO
  Caption = "Result";
  Width = 400;
  Height = 400;
  ManualDock(FMain->PageControl,FMain->PageControl,alClient);
  FMain->PageControl->FindNextPage(FMain->PageControl->Pages[0],true,true);
  Visible = true;
}
//---------------------------------------------------------------------------
void
TFResult::Init(void) {
  // sEBhẼXN[o[ɖ߂
  REResult->Lines->Clear();
  int firstline = REResult->Perform(EM_GETFIRSTVISIBLELINE,0,0);
  REResult->Perform(EM_LINESCROLL,0,-firstline);
}
//---------------------------------------------------------------------------
/**
 * ʂ̓ǂݍ
 * TRichEdit->Lines->LoadFromStream̃bp[ɂȂĂ
 */
//---------------------------------------------------------------------------
void
TFResult::LoadFromStream(TStream *Stream) {
  REResult->Lines->LoadFromStream(Stream);
}
//---------------------------------------------------------------------------
/**
 * EBhEɃtH[JXĂ
 */
void
TFResult::SetWindowFocus(void) {
  REResult->SetFocus();
}
//---------------------------------------------------------------------------
/**
 * J[\ʒuʓɔzuR[h
 */
void
TFResult::MakeCursorVisible(void) {
  const int TopLineMargin = 5;
  int firstline = REResult->Perform(EM_GETFIRSTVISIBLELINE,0,0);
  int line = REResult->Perform(EM_LINEFROMCHAR,-1,0);
  if(line>TopLineMargin) {
    firstline += TopLineMargin;
    REResult->Perform(EM_LINESCROLL,0,line-firstline);
  } else {
    REResult->Perform(EM_LINESCROLL,0,-firstline);
  }
}
//---------------------------------------------------------------------------
/**
 * 
 */
void
TFResult::Find(void) {
  FMain->FindDialog->OnFind = OnFind;
  SearchOption.Clear();
  FMain->FindDialog->FindText = FindWord;
  if(!FMain->FindDialog->Execute()) {
    return;
  }
}
//---------------------------------------------------------------------------
void __fastcall
TFResult::OnFind(TObject *Sender) {
  FMain->FindDialog->CloseDialog();
  FindWord = FMain->FindDialog->FindText;
  //IvV̐ݒ
  if (FMain->FindDialog->Options.Contains(frMatchCase)) {
    SearchOption = SearchOption << stMatchCase;
  }
  if (FMain->FindDialog->Options.Contains(frWholeWord)) {
    SearchOption = SearchOption << stWholeWord;
  }
  if (FMain->FindDialog->Options.Contains(frDown)) {
    //Ɍ
    FindNext();
  } else {
    //Ɍ
    FindPrev();
  }

}
//---------------------------------------------------------------------------
/**
 * 
 */
void
TFResult::FindNext(void) {
  if(FindWord == "") {
    Find();
    return;
  }

  //݂̃J[\ʒu̍s
  int line = REResult->Perform(EM_LINEFROMCHAR,-1,0);

  //J[\s̓̈ʒu
  int linetop = REResult->Perform(EM_LINEINDEX,line,0);
  AnsiString Str = REResult->Lines->Strings[line];
  int startpos = REResult->SelStart;
  if(REResult->SelLength)
    startpos++;
  Str = Str.SubString(startpos - linetop+1,Str.Length()-startpos+linetop);

  //݂̈ʒuŌ邩
  int pos = Str.AnsiPos(FindWord);
  if(pos!=0) {
    pos += startpos-1;
    REResult->SelStart = pos;
    REResult->SelLength = FindWord.Length();
    MakeCursorVisible();
    return;
  }
  //ȉ̍s
  line++;
  int count = REResult->Lines->Count;//QƂƒx̂őޔ
  while(line < count) {
    Str = REResult->Lines->Strings[line];
    int pos = Str.AnsiPos(FindWord);
    if(pos!=0) {
      int linetop = REResult->Perform(EM_LINEINDEX,line,0);
      pos += linetop-1;
      REResult->SelStart = pos;
      REResult->SelLength = FindWord.Length();
      MakeCursorVisible();
      return;
    } else {
      line++;
    }
  }
}
//---------------------------------------------------------------------------
/**
 * ^ꂽ̍ŌɃ}b`ʒuԂ
 * }b`Ȃ 0Ԃ
 */
int
FindLast(AnsiString asTarget, AnsiString asFindWord) {
  int pos = asTarget.AnsiPos(asFindWord);
  if(pos==0) {
    return 0;
  }
  while(1) {
    asTarget = asTarget.SubString(pos+1,asTarget.Length()-pos);
    int pos2 = asTarget.AnsiPos(asFindWord);
    if(pos2!=0) {
      pos+=pos2;
    } else {
      break;
    }
  }
  return pos;
}
//---------------------------------------------------------------------------
void
TFResult::FindPrev(void) {

  //݂̃J[\ʒu̍s
  int line = REResult->Perform(EM_LINEFROMCHAR,-1,0);

  //J[\s̓̈ʒu
  int linetop = REResult->Perform(EM_LINEINDEX,line,0);
  AnsiString Str = REResult->Lines->Strings[line];
  Str = Str.SubString(0,REResult->SelStart-linetop-1);
  int pos = FindLast(Str,FindWord);
  if(pos!=0) {
    pos += linetop-1;
    REResult->SelStart = pos;
    REResult->SelLength = FindWord.Length();
    return;
  } else {
    line--;
  }
  while(line >= 0) {
    Str = REResult->Lines->Strings[line];
    int pos = FindLast(Str,FindWord);
    if(pos!=0) {
      int linetop = REResult->Perform(EM_LINEINDEX,line,0);
      pos += linetop-1;
      REResult->SelStart = pos;
      REResult->SelLength = FindWord.Length();
      MakeCursorVisible();
      return;
    } else {
      line--;
    }
  }
}
//---------------------------------------------------------------------------
// Nbv{[h
//---------------------------------------------------------------------------
/**
 * ؂
 */
void
TFResult::Cut(void) {
  if(REResult->SelText=="") {
    return;
  }
  TClipboard *cb = Clipboard();
  cb->AsText = REResult->SelText;
  REResult->Lines->BeginUpdate();
  REResult->Perform(EM_REPLACESEL,true,(int)"");
  REResult->Lines->EndUpdate();
}
//---------------------------------------------------------------------------
/**
 * Rs[
 */
void
TFResult::Copy(void) {
  if(REResult->SelText=="") {
    return;
  }
  TClipboard *cb = Clipboard();
  cb->AsText = REResult->SelText;
}
//---------------------------------------------------------------------------
/**
 * \t
 */
void
TFResult::Paste(void) {
  TClipboard *cb = Clipboard();
  REResult->Lines->BeginUpdate();
  REResult->Perform(EM_REPLACESEL,true,(int)(cb->AsText.c_str()));
  REResult->Lines->EndUpdate();
}
//---------------------------------------------------------------------------
// GfBbg֘A
//---------------------------------------------------------------------------
/**
 * AhD
 */
void
TFResult::Undo(void) {
  REResult->Perform(EM_UNDO,0,0);
}
//---------------------------------------------------------------------------
void __fastcall
TFResult::FormActivate(TObject *Sender) {
  FMain->ChangeWindow(RESULT_WINDOW);
}
//---------------------------------------------------------------------------
/**
 * Xe[^Xo[\p̕
 */
AnsiString
TFResult::GetCaretString(void) {
  AnsiString as;
  int line_number = SendMessage(REResult->Handle,EM_LINEFROMCHAR,REResult->SelStart,0);
  int line_pos = SendMessage(REResult->Handle,EM_LINEINDEX,line_number,0);
  int pos = REResult->SelStart - line_pos;
  as+=" "+IntToStr(line_number+1);
  as+=": ";
  as+=IntToStr(pos+1);
  if(REResult->SelLength!=0) {
    as+=" ("+IntToStr(REResult->SelLength)+")";
  }
  return as;
}
//---------------------------------------------------------------------------
void
TFResult::Save(void) {
  FMain->SaveDialog->FileName = "";
  FMain->SaveDialog->Filter = "All Files(*.*)|*.*";
  FMain->SaveDialog->Title = "sʂۑ";
  FMain->SaveDialog->InitialDir = GetMyCurrentDir();
  FMain->SaveDialog->DefaultExt = "";

  if(!FMain->SaveDialog->Execute()) {
    return;
  }
  AnsiString FileName = FMain->SaveDialog->FileName;
  if(FMain->SaveDialog->FileName.LowerCase().Trim() == FScript->GetFileName().LowerCase().Trim()) {
    ShowMessage("ʃt@CŃXNvgt@C㏑悤ƂĂ܂B\nt@CςĕۑĂB");
    return;
  }
  SaveToFile(FileName);
  SetMyCurrentDir(ExtractFileDir(FileName));
  FMain->UpdateStatusBar();
}
//---------------------------------------------------------------------------
void
TFResult::SaveAs(void) {
  Save();
}
//---------------------------------------------------------------------------
/**
 * t@Cɕۑ
 */
void
TFResult::SaveToFile(AnsiString FileName) {
  FMain->GetCopalConfig()->SaveResultFile = FileName;
  REResult->Lines->SaveToFile(FileName);
  /*
  if(FScript->GetCode()!=D_CRLF || FScript->GetDelimiter()!=C_SJIS)
    {
     //R[hϊ̕Kv
     SaveConvertedFile(FileName,REResult->Lines->Text,FScript->GetCode(),FScript->GetDelimiter());
    }
  else
    {
     //R[hϊ̕KvȂ
     REResult->Lines->SaveToFile(FileName);
    }
  */
}
//---------------------------------------------------------------------------
// Cxg֘A
//---------------------------------------------------------------------------
void __fastcall
TFResult::FormKeyUp(TObject *Sender, WORD &Key,
                    TShiftState Shift) {
  FMain->UpdateMenu();
  FMain->UpdateStatusBar();
}
//---------------------------------------------------------------------------
void __fastcall
TFResult::REResultChange(TObject *Sender) {
  FMain->UpdateStatusBar();
}
//---------------------------------------------------------------------------

void __fastcall
TFResult::REResultMouseDown(TObject *Sender,
                            TMouseButton Button, TShiftState Shift, int X, int Y) {
  FMain->UpdateStatusBar();
}
//---------------------------------------------------------------------------
void __fastcall
TFResult::REResultMouseUp(TObject *Sender,
                          TMouseButton Button, TShiftState Shift, int X, int Y) {
  FMain->UpdateStatusBar();
}
//---------------------------------------------------------------------------

void __fastcall
TFResult::REResultKeyUp(TObject *Sender, WORD &Key, TShiftState Shift) {
  FMain->UpdateStatusBar();
}
//---------------------------------------------------------------------------

