//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "LangConfig.h"
#include "Main.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFLangConfig *FLangConfig;
//---------------------------------------------------------------------------
__fastcall TFLangConfig::TFLangConfig(TComponent* Owner)
    : TForm(Owner) {}
//---------------------------------------------------------------------------
/**
 * s\bh
 * `󂯎
 */
void TFLangConfig::Execute(KCopalConfig *_CopalConfig) {
  CopalConfig = _CopalConfig;
  //R{{bNX̍쐬
  CBLanguage->Items->Clear();
  //int index = -1;
  for(int i=0;i<CopalConfig->GetDefConfigCount();i++) {
    KDefConfig *dc = CopalConfig->GetDefConfigAt(i);
    CBLanguage->Items->Add(dc->LangName);
    if(dc->LangName == CopalConfig->GetLangName()) {
      CBLanguage->ItemIndex = i;
    }
  }

  //\
  ShowConfig();
  ShowModal();
}
//---------------------------------------------------------------------------
/**
 * RtBO\
 */
void TFLangConfig::ShowConfig(void) {
  KDefConfig *DefConfig =  CopalConfig->GetCurrentLanguage();

  //ݒ
  EdExePath->Text = DefConfig->ExePath;
  EdOption->Text = DefConfig->Option;
  EdExt->Text = DefConfig->LangExt;

  //GfB^
  CBUseHelpFile->Checked = DefConfig->UseHelpFile;
  EdHelpFile->Text = DefConfig->HelpFile;
  EdTempFile->Text = DefConfig->TempFile;
  EdTempDir->Text = DefConfig->TempDir;

  //fobO
  CBShowError->Checked = DefConfig->ShowError;
  CBCheckErrorCode->Checked = DefConfig->CheckErrorCode;

  EdRegExpErr->Text    = DefConfig->RegExpErr;

  CBUseTagJumpToOtherFile->Checked = DefConfig->UseTagJumpToOtherFile;
  EdRegExpFile->Text = DefConfig->RegExpFile;
}
//---------------------------------------------------------------------------
/**
 * RtBO`FbN
 * Ԃl: 肪true
 *         肪 false
 */
bool
TFLangConfig::CheckConfig(void) {

  if(!FileExists(EdExePath->Text)) {
    PageControl->ActivePage = TSEnvironment;
    EdExePath->SetFocus();
    ShowMessage("t@C " + EdExePath->Text + " ݂͑܂B\n݂s\t@Cւ̃pXݒ肵ĂB");
    return false;
  }

  if(CBUseTagJumpToOtherFile->Checked) {
    if(EdRegExpFile->Text.Trim() == "") {
      PageControl->ActivePage = TSDebug;
      EdRegExpFile->SetFocus();
      ShowMessage("G[t@C擾p̐K\ݒ肵Ă");
      return false;
    }
    if(!FMain->GetCopalConfig()->UseTagJump) {
      ShowMessage(
        "ʂ̃t@CɃ^OWv邽߂ɂ́A^OWv̐ݒ肪KvłB\n"
        "[ݒ][GfB^]Ń^OWvɕKvȐݒsĂB"
      );
      return true;
    }
  }
  return true;
}
//---------------------------------------------------------------------------
/**
 * RtBOXV
 */
void
TFLangConfig::SetConfig(void) {
  KDefConfig *DefConfig =  CopalConfig->GetCurrentLanguage();

  //ݒ
  DefConfig->ExePath = EdExePath->Text;
  DefConfig->Option = EdOption->Text;
  DefConfig->LangExt = EdExt->Text;

  //GfB^
  DefConfig->UseHelpFile = CBUseHelpFile->Checked;
  DefConfig->HelpFile = EdHelpFile->Text;
  DefConfig->TempFile = EdTempFile->Text;

  if(EdTempDir->Text!="" && EdTempDir->Text[EdTempDir->Text.Length()] =='\\') {
    EdTempDir->Text = EdTempDir->Text.SubString(1,EdTempDir->Text.Length()-1);
  }

  DefConfig->TempDir = EdTempDir->Text;

  //fobO
  DefConfig->ShowError = CBShowError->Checked;
  DefConfig->CheckErrorCode = CBCheckErrorCode->Checked;
  DefConfig->RegExpErr = EdRegExpErr->Text;

  DefConfig->UseTagJumpToOtherFile = CBUseTagJumpToOtherFile->Checked;
  DefConfig->RegExpFile = EdRegExpFile->Text;

  CopalConfig->Save();
}
//---------------------------------------------------------------------------
/**
 * ̐؂ւ
 */
void __fastcall TFLangConfig::CBLanguageChange(TObject *Sender) {
  CopalConfig->ChangeLanguage(CBLanguage->ItemIndex);
  ShowConfig();
}
//---------------------------------------------------------------------------

void __fastcall TFLangConfig::BtOKClick(TObject *Sender) {
  if(!CheckConfig())
    return;
  SetConfig();
  ModalResult = mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TFLangConfig::BtCancelClick(TObject *Sender) {
  ModalResult = mrCancel;
}
//---------------------------------------------------------------------------
void __fastcall TFLangConfig::BtSetClick(TObject *Sender) {
  SetConfig();
}
//---------------------------------------------------------------------------
void __fastcall TFLangConfig::FormKeyPress(TObject *Sender, char &Key) {
  switch(Key) {
  case VK_RETURN:
    Key = 0;
    BtOK->Click();
    break;
  case VK_ESCAPE:
    Key = 0;
    BtCancel->Click();
    break;
  }
}
//---------------------------------------------------------------------------
void __fastcall TFLangConfig::BtBrouseExepathClick(TObject *Sender) {
  AnsiString Temp = GetCurrentDir();
  OpenDialog->Filter = "st@C(*.exe,*.com)|*.exe;*.com|SẴt@C(*.*)|*.*";
  if(!OpenDialog->Execute()) {
    OpenDialog->Filter = "";
    return;
  }
  EdExePath->Text = OpenDialog->FileName;
  SetCurrentDir(Temp);
}
//---------------------------------------------------------------------------
void __fastcall TFLangConfig::BtBrouseHelpFileClick(TObject *Sender) {
  AnsiString Temp = GetCurrentDir();
  OpenDialog->Filter = "wvt@C(*.hlp,*.chm)|*.hlp;*.chm|SẴt@C(*.*)|*.*";
  if(!OpenDialog->Execute()) {
    OpenDialog->Filter = "";
    return;
  }
  EdHelpFile->Text = OpenDialog->FileName;
  SetCurrentDir(Temp);
}
//---------------------------------------------------------------------------


