//---------------------------------------------------------------------------
// qvZXNAWo͂NX
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "KExecProc.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)


const int BUFFER_SIZE = 4097;//pCṽobt@TCY
//---------------------------------------------------------------------------
/**
 * RXgN^
 */
KExecProc::KExecProc(AnsiString cmd) {
  kThread = new KThread(true);
  CommandLine = cmd;
  msStdOut = new TMemoryStream;//Wo͗p
  msStdErr = new TMemoryStream;//WG[p
  lpEnvironment = NULL;
}
//---------------------------------------------------------------------------
/**
 * fXgN^
 */
KExecProc::~KExecProc(void) {
  if(lpEnvironment != NULL)
    delete lpEnvironment;
  delete kThread;
  delete msStdOut;
  delete msStdErr;
}
//---------------------------------------------------------------------------
/**
 * ϐf[^󂯎
 */
void
KExecProc::SetEnvironment(char *b) {
  if(lpEnvironment != NULL) {
    ShowMessage("KExecProc::SetEnvironment\nAsertionFailed.");
  }
  lpEnvironment = b;
}
//---------------------------------------------------------------------------
/**
 * qvZXN
 */
bool
KExecProc::Execute(void) {
  //sĎXbh𗧂グ

  //SECURITY_ATTRIBUTE̐ݒ

  SECURITY_ATTRIBUTES saStdOut,saStdErr;
  saStdOut.nLength = sizeof( SECURITY_ATTRIBUTES );
  saStdOut.bInheritHandle = true;
  saStdOut.lpSecurityDescriptor = NULL;

  saStdErr.nLength = sizeof( SECURITY_ATTRIBUTES );
  saStdErr.bInheritHandle = true;
  saStdErr.lpSecurityDescriptor = NULL;

  //̃vZXSTDOUT,STDERRnh̕ۑ
  HANDLE hSaveStdout = GetStdHandle(STD_OUTPUT_HANDLE);
  HANDLE hSaveStderr = GetStdHandle(STD_ERROR_HANDLE);

  //qvZXւ̃pCvB
  HANDLE hStdOutWriteEnd,hStdOutReadEnd;
  HANDLE hStdErrWriteEnd,hStdErrReadEnd;

  if (!CreatePipe(&hStdOutReadEnd, &hStdOutWriteEnd, &saStdOut, 0)) {
    SetErrorMessage("Cannot create a Pipe(StdOut)");
    return false;
  }
  if (!CreatePipe(&hStdErrReadEnd, &hStdErrWriteEnd, &saStdErr, 0)) {
    SetErrorMessage("Cannot create a Pipe(StdErr)");
    return false;
  }

  PROCESS_INFORMATION pi;
  STARTUPINFO si;
  GetStartupInfo(&si);
  si.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW;
  si.wShowWindow = SW_HIDE;
  si.hStdOutput = hStdOutWriteEnd;
  si.hStdError = hStdErrWriteEnd;

  //vZX̍쐬
  if (!CreateProcess(NULL,CommandLine.c_str(), NULL, NULL, TRUE, 0, lpEnvironment, NULL, &si, &pi)) {
    SetErrorMessage("Cannot create a proccess.");
    return false;
  }
  // ̃vZX̕Wo͂ɖ߂B
  if (!SetStdHandle(STD_OUTPUT_HANDLE, hSaveStdout)) {
    SetErrorMessage("Cannot restore STDOUT");
    return false;
  }
  if (!SetStdHandle(STD_ERROR_HANDLE, hSaveStderr)) {
    SetErrorMessage("Cannot restore STDERR");
    return false;
  }
  //pCvǂݍޑOɏݒ[B
  if ( !CloseHandle( hStdOutWriteEnd) ) {
    SetErrorMessage("Cannot close stdout write end.");
    return false;
  }
  if ( !CloseHandle( hStdErrWriteEnd) ) {
    SetErrorMessage("Cannot close stderr write end.");
    return false;
  }

  //XbhɃnhn

  kThread->SetHandle(pi.hProcess);
  kThread->Resume();

  //pCvǂݍ݂̏

  DWORD exitcode = 1;//ItO
  char bufStdOut[BUFFER_SIZE],bufStdErr[BUFFER_SIZE];//ǂݍbuffer
  DWORD readbufStdOut = 0,readbufStdErr = 0;//ǂݍ񂾃oCg

  SetLastError(-1);

  //Xg[̏
  msStdOut->Clear();
  msStdErr->Clear();

  //vZXĎ閳C[v

  while(1) {

    //exitcode𒲂ׂ
    if(GetExitCodeProcess(pi.hProcess,&exitcode)==false) {
      SetErrorMessage("Error:Fail to ExitCodeProcess\n");
      break;
    }

    if (exitcode !=STILL_ACTIVE)
      break;

    if (GetAsyncKeyState(VK_ESCAPE)<0) {
      ShowMessage("͒f܂");
      break;
    }

    do {
      if(!ReadFile(hStdOutReadEnd,bufStdOut,sizeof(bufStdOut),&readbufStdOut,NULL))
        break;
      if(readbufStdOut) {
        msStdOut->Write(bufStdOut,readbufStdOut);
      }
    } while(readbufStdOut!=0);


    if(!ReadFile(hStdErrReadEnd,bufStdErr,sizeof(bufStdErr),&readbufStdErr,NULL))
      break;
    if(readbufStdErr) {
      msStdErr->Write(bufStdErr,readbufStdErr);
    }
  }

  //vZXȈ

  CloseHandle(hStdOutReadEnd);
  CloseHandle(hStdErrReadEnd);

  //XbhE
  kThread->Terminate();

  if(GetExitCodeProcess(pi.hProcess,&exitcode)==false) {
    SetErrorMessage("Error:Fail to ExitCodeProcess\n");
    return false;
  }
  ExitCode = exitcode;

  if(ExitCode!=0) {
    return false;
  } else {
    return true;
  }
}
//---------------------------------------------------------------------------
