//---------------------------------------------------------------------------
// Copal ̃RtBOێNX
// `t@CǗ
//---------------------------------------------------------------------------
#ifndef KCopalConfigH
#define KCopalConfigH
//---------------------------------------------------------------------------
#include "KDefConfig.h"
#include "Editor.h"
#include "Script.h"

const int CM_AUTOSELECT = -1;
const int CM_SJIS = C_SJIS;
const int CM_EUC = C_EUC;
const int CM_JIS = C_JIS;
const int CM_UTF8 = C_UTF8;

//---------------------------------------------------------------------------
// ۑɕKvȏ
//---------------------------------------------------------------------------
struct CONFIGSAVEPARAM {
  bool Maximized;
  int  Width,Height;
};

//---------------------------------------------------------------------------
class KCopalConfig {
private:

  TList *DefFileList;//`t@C̃Xg
  KDefConfig *CurrentLanguage;//ݎw肳Ă錾

  //---------------------------------------------------------------------------
  // s̏ԂǗ
  //---------------------------------------------------------------------------

  bool Maximized;    //EBhEő剻Ă邩
  int Height,Width;  //EBhE̍A

  bool FEditorStayOnTop;//ϐGfB^őOʂɕ\邩


  int TabWidth;
  bool ReadOnly;
  bool bUseHotKey;//zbgL[gp邩
  TShortCut HotKey; //zbgL[
  int DefaultCode;// ftHg̃R[h
  static const int DefaultTabWidth = 4;

  //---------------------------------------------------------------------------
public:
  KCopalConfig(AnsiString _DefaultPath);//RXgN^
  ~KCopalConfig();//fXgN^

  //---------------------------------------------------------------------------
  // ꎞIɋLϐ
  //---------------------------------------------------------------------------
  AnsiString LastDroppedFiles;
  AnsiString SaveResultFile;

  //---------------------------------------------------------------------------
  //sɕKvȏԂ
  //---------------------------------------------------------------------------
  AnsiString GetLangName(void) {
    return CurrentLanguage->LangName;
  };

  AnsiString GetExePath(void) {
    return CurrentLanguage->ExePath;
  };

  AnsiString GetOption(void) {
    return CurrentLanguage->Option;
  };

  AnsiString GetRegExpErr(void) {
    return CurrentLanguage->RegExpErr;
  };

  bool GetUseTagJumpToOtherFile(void) {
    return CurrentLanguage->UseTagJumpToOtherFile;
  };

  AnsiString GetRegExpFile(void) {
    return CurrentLanguage->RegExpFile;
  };

  AnsiString GetTempFile(void);

  bool GetUseHelp(void) {
    return CurrentLanguage->UseHelpFile;
  };

  AnsiString GetHelpFile(void) {
    return CurrentLanguage->HelpFile;
  };

  bool GetShowError(void) {
    return CurrentLanguage->ShowError;
  };


  KDefConfig *GetCurrentLanguage(void) {
    return CurrentLanguage;
  };

  //---------------------------------------------------------------------------
  //sɕKvȏZbg
  //---------------------------------------------------------------------------
  void SetLangName(AnsiString LangName) {
    CurrentLanguage->LangName = LangName;
  }
  ;//
  void SetExePath(AnsiString ExePath) {
    CurrentLanguage->ExePath = ExePath;
  }
  ;//
  void SetOption(AnsiString Option) {
    CurrentLanguage->Option = Option;
  }
  ;//

  bool CheckPath(void);//s\`FbN

  AnsiString GetFileFilter(void);//t@C̃tB^[쐬

  //---------------------------------------------------------------------------
  //`t@C֌W
  //---------------------------------------------------------------------------
  void CreateDefConfig(AnsiString LangName,AnsiString LangPath);
  void SearchDefFiles(void);//`t@CT
  void SearchByName(AnsiString LangName);//`t@CŌ
  bool SearchByExt(AnsiString Ext);//gqŌ
  bool LanguageExists(AnsiString LangName);

  void AddDefConfig(KDefConfig *DefConfig);
  int GetDefConfigCount(void) {
    return DefFileList->Count;
  };
  KDefConfig* GetDefConfigAt(int index) {
    return (KDefConfig*)DefFileList->Items[index];
  };
  void DeleteAllDefConfig(void);//`t@CSč폜
  void DeleteDefConfigAt(int index);//`t@C폜

  void ChangeLanguage(KDefConfig *df);
  void ChangeLanguage(int index) {
    ChangeLanguage(GetDefConfigAt(index));
  };

  AnsiString GetDefaultExt(void) {
    return CurrentLanguage->GetDefaultExt();
  }
  bool CheckErrorCode(void) {
    return CurrentLanguage->CheckErrorCode;
  }

  //t@CApX֌W
  AnsiString FileName;//̃t@C
  AnsiString HelpFile;//wvt@C
  AnsiString ShortCutKeyFile;//V[gJbgt@C
  AnsiString TempBat;//ꎞIȃob`t@C
  AnsiString TempHtml;//ꎞIȂgslkt@C


  bool UsePause;//ŌPAUSEf
  bool CutHead;//wb_Jbg

  AnsiString DefaultPath;//s\t@ĈtH_
  AnsiString DefFilesPath;//`t@ĈfBNg

  AnsiString Editor;
  bool UseDoubleQuotes;

  //---------------------------------------------------------------------------
  bool AutoRefresh;
  bool ReadOnlyWhenAutoRefresh;//I[gtbVɃt@CJƂҏW֎~Ƃ邩
  bool UseCGI;
  //---------------------------------------------------------------------------
  void SetReadOnly(bool b);
  bool IsReadOnly(void) {return ReadOnly;};
  //---------------------------------------------------------------------------
  void ChangeHotKey(bool _UseHotKey, TShortCut _HotKey);
  void SetHotKey(TShortCut _HotKey);
  void UnsetHotKey(void);
  TShortCut GetHotKey(void) {
    return HotKey;
  };
  bool UseHotKey(void) {
    return bUseHotKey;
  };
  //---------------------------------------------------------------------------
  int GetCodeMode(void);
  void SetCodeMode(int);
  char * GetCodeStr(void);

  //---------------------------------------------------------------------------
  // EBhEݒ
  //---------------------------------------------------------------------------

  bool isMaximized(void) {
    return Maximized;
  }
  ;//ő剻ׂ
  void SetWindowHeight(int h) {
    Height = h;
  };
  void SetWindowWidth(int h) {
    Height = h;
  };

  void SetFEditorStayOnTop(void) {
    FEditor->SetStayOnTop(FEditorStayOnTop);
  };

  //---------------------------------------------------------------------------
  // fobO֌W
  //---------------------------------------------------------------------------

  bool UseTagJump;//^OWvg
  AnsiString TagJumpText;//^OWvpIvV
  AnsiString GetTagJumpText(void) {
    return TagJumpText;
  };

  //---------------------------------------------------------------------------
  // ̑
  //---------------------------------------------------------------------------

  void SetTabWidth(int width);
  int GetTabWidth(void){return TabWidth;};
  void SetTabWidthToRichEdit(TRichEdit *re, int w);
  bool MemoryFileWhenDropped;//t@Chbvɂ̃t@CL
  bool ChangeCurrentDirOnDrop;//t@ChbvɃfBNgύX
  bool DontChangeDirFromDesktop;//fXNgbvhbvꂽύXȂ

  //ۑAǍ
  void Load(void);
  void Save(CONFIGSAVEPARAM csp);
  void Save(void);
  void SaveAllDefConfig(void);

};
//---------------------------------------------------------------------------
#endif
