//---------------------------------------------------------------------------
// Copal ̃RtBOێNX
// `t@CǗ
//---------------------------------------------------------------------------
#include <vcl.h>
#include <Inifiles.hpp>
#include <filectrl.hpp>
#pragma hdrstop


#include "KCopalConfig.h"
#include "Main.h"
#pragma package(smart_init)


const char *HotKeyIDStr = "CopalHotKey";

//---------------------------------------------------------------------------
/**
 * RXgN^
 * ftHgtH_Ƃ
 */
KCopalConfig::KCopalConfig(AnsiString _DefaultPath) {
  //
  DefaultPath = _DefaultPath;
  FileName = DefaultPath +"CopalPro.cfg";
  DefFilesPath = DefaultPath +"defs\\";
  HelpFile = DefaultPath +"CopalPro.hlp";//wvt@C
  ShortCutKeyFile = DefaultPath +"CopalPro.key";//V[gJbgL[t@C

  LastDroppedFiles = "";
  SaveResultFile = "";


  //̑
  bUseHotKey = false;
  AutoRefresh = false;
  ReadOnly = false;
  UseCGI = false;
  HotKey = 0;
  DefaultCode = CM_AUTOSELECT;
  TabWidth = DefaultTabWidth;

  DefFileList = new TList;
}
//---------------------------------------------------------------------------
/**
 * fXgN^
 */
KCopalConfig::~KCopalConfig(void) {
  UnsetHotKey();
  delete DefFileList;
}
//---------------------------------------------------------------------------
/**
 * RtBOf[^̕ۑ
 * EBhEȊOۑ
 */
void
KCopalConfig::Save(void) {
  SaveAllDefConfig();

  TIniFile *IniFile = new TIniFile(FileName);

  //݂̌ۑ
  IniFile->WriteString("Environment","Language",CurrentLanguage->LangName);

  //GfB^
  IniFile->WriteString("Environment","Editor",Editor);
  IniFile->WriteBool("Environment","UseDoubleQuotes",UseDoubleQuotes);

  //^OWv
  IniFile->WriteBool("Environment","UseTagJump",UseTagJump);
  IniFile->WriteString("Environment","TagJumpText",TagJumpText);

  //DOSł̎s
  IniFile->WriteString("Environment","TempBat",TempBat);
  IniFile->WriteBool("Environment","UsePause",UsePause);

  //zbgL[
  IniFile->WriteBool("Environment","UseHotKey",bUseHotKey);
  IniFile->WriteInteger("Environment","HotKey",(int)HotKey);

  //I[gtbV
  IniFile->WriteBool("Environment","AutoRefresh",AutoRefresh);
  IniFile->WriteBool("Environment","ReadOnlyWhenAutoRefresh",ReadOnlyWhenAutoRefresh);

  //CGIݒ
  IniFile->WriteString("Environment","TempHtml",TempHtml);
  IniFile->WriteBool("Environment","CutHead",CutHead);

  //R[h̎w
  IniFile->WriteInteger("Environment","DefaultCode",GetCodeMode());

  //t@CqXg̕ۑ
  FMain->SaveHistory(IniFile);

  //̑
  IniFile->WriteBool("Others","MemoryFileWhenDropped",MemoryFileWhenDropped);
  IniFile->WriteBool("Others","ChangeCurrentDirOnDrop",ChangeCurrentDirOnDrop);
  IniFile->WriteBool("Others","DontChangeDirFromDesktop",DontChangeDirFromDesktop);
  IniFile->WriteBool("Others","FEditorStayOnTop",FEditor->isStayOnTop());

  delete IniFile;
}
//---------------------------------------------------------------------------
/**
 * RtBOf[^̕ۑ
 * EBhE݂ŕۑ
 * IɌĂ΂
 */
void
KCopalConfig::Save(CONFIGSAVEPARAM csp) {

  TIniFile *IniFile = new TIniFile(FileName);
  //EBhEۑ
  IniFile->WriteBool("Window","Maximized",csp.Maximized);
  IniFile->WriteInteger("Window","Height",csp.Height);
  IniFile->WriteInteger("Window","Width",csp.Width);
  delete IniFile;
  Save();

}
//---------------------------------------------------------------------------
/**
 * RtBOf[^̓ǂݍ
 */
void
KCopalConfig::Load(void) {
  TIniFile *IniFile = new TIniFile(FileName);

  AnsiString LangName = IniFile->ReadString("Environment","Language","Perl");
  SearchByName(LangName);

  //GfB^ǂݍ
  Editor = IniFile->ReadString("Environment","Editor","notepad.exe");
  UseDoubleQuotes = IniFile->ReadBool("Environment","UseDoubleQuotes",false);

  //^OWv
  UseTagJump = IniFile->ReadBool("Environment","UseTagJump",false);
  TagJumpText = IniFile->ReadString("Environment","TagJumpText","");

  //DOSł̎s
  TempBat = IniFile->ReadString("Environment","TempBat","temp.bat");
  UsePause = IniFile->ReadBool("Environment","UsePause",false);

  //zbgL[
  bUseHotKey = IniFile->ReadBool("Environment","UseHotKey",false);
  HotKey = (TShortCut)IniFile->ReadInteger("Environment","HotKey",0);
  ChangeHotKey(bUseHotKey,HotKey);

  //I[gtbV
  AutoRefresh = IniFile->ReadBool("Environment","AutoRefresh",false);
  ReadOnlyWhenAutoRefresh = IniFile->ReadBool("Environment","ReadOnlyWhenAutoRefresh",false);


  //EBhEǂݍ
  Maximized = IniFile->ReadBool("Window","Maximized",false);

  FMain->Width = IniFile->ReadInteger("Window","Width",600);
  FMain->Height = IniFile->ReadInteger("Window","Height",400);

  //CGIݒ
  TempHtml = IniFile->ReadString("Environment","TempHtml","temp.html");
  CutHead = IniFile->ReadBool("Environment","CutHead",true);

  //R[h̎w
  DefaultCode = IniFile->ReadInteger("Environment","DefaultCode",-1);

  //t@CqXg̓ǂݍ
  FMain->LoadHistory(IniFile);

  //̑
  MemoryFileWhenDropped = IniFile->ReadBool("Others","MemoryFileWhenDropped",false);
  ChangeCurrentDirOnDrop = IniFile->ReadBool("Others","ChangeCurrentDirOnDrop",false);
  DontChangeDirFromDesktop = IniFile->ReadBool("Others","DontChangeDirFromDesktop",false);
  FEditorStayOnTop = IniFile->ReadBool("Others","FEditorStayOnTop",false);

  delete IniFile;
}
//---------------------------------------------------------------------------
// `t@C̊Ǘ
//---------------------------------------------------------------------------
/**
 * `t@CVɍ
 */
void
KCopalConfig::CreateDefConfig(AnsiString LangName,AnsiString LangPath) {
  AnsiString FileName = DefFilesPath+LangName+".def";
  KDefConfig *dc = new KDefConfig(FileName,LangName,LangPath);
  AddDefConfig(dc);
  ChangeLanguage(dc);
  ShowMessage(LangName + "@ǉ܂B\n ڍאݒ͐ݒ胁j[̌ʐݒ肩sĂ");
}
//---------------------------------------------------------------------------
/**
 * `t@Cۑ
 */
void
KCopalConfig::SaveAllDefConfig(void) {
  for(int i=0;i<GetDefConfigCount();i++) {
    GetDefConfigAt(i)->SaveToFile();
  }
}
//---------------------------------------------------------------------------
/**
 * `t@C
 */
void
KCopalConfig::AddDefConfig(KDefConfig *DefConfig) {
  DefFileList->Add(DefConfig);
}
//---------------------------------------------------------------------------
/**
 * `t@C폜
 */
void
KCopalConfig::DeleteDefConfigAt(int index) {
  KDefConfig *dc = GetDefConfigAt(index);
  delete dc;
  DefFileList->Delete(index);
}
//---------------------------------------------------------------------------
/**
 * `t@CSč폜
 */
void
KCopalConfig::DeleteAllDefConfig(void) {
  for(int i=0;GetDefConfigCount()!=0;i++) {
    DeleteDefConfigAt(0);
  }
}
//---------------------------------------------------------------------------
/**
 * DefFilesPath̃tH_`t@CT
 * Tt@CnewăXgɉ
 */
void
KCopalConfig::SearchDefFiles(void) {
  //DEFt@C
  TStringList *st1= new TStringList;

  //deftH_΍쐬
  if(!FileExists(DefFilesPath)) {
    CreateDir(DefFilesPath);
  }

  TSearchRec sr;
  if(FindFirst(DefFilesPath+"*.def", faAnyFile, sr)==0) {
    KDefConfig *dc = new KDefConfig(DefFilesPath + sr.Name);
    AddDefConfig(dc);
    while(FindNext(sr)==0) {
      dc = new KDefConfig(DefFilesPath + sr.Name);
      AddDefConfig(dc);
    }
    FindClose(sr);
  }
  delete st1;

  //`t@C΁AftHg̃t@C쐬
  if(GetDefConfigCount()==0) {
    ShowMessage("Def Files are not found. Use default Settings.");
    KDefConfig *dc = new KDefConfig(DefFilesPath + "perl.def");
    AddDefConfig(dc);
  }

  //Ô߁ACurrentLanguagew肵Ă
  ChangeLanguage(GetDefConfigAt(0));
}
//---------------------------------------------------------------------------
/**
 * ݎw肳Ă錾ύX
 */
void
KCopalConfig::ChangeLanguage(KDefConfig *df) {
  CurrentLanguage = df;
}
//---------------------------------------------------------------------------
bool
isDirectoryExists(LPCTSTR filename) {
  WIN32_FIND_DATA ffd;

  // w肳ꂽt@Cƈvt@C
  HANDLE hFindFile = FindFirstFile(filename, &ffd);

  // t@Cnh
  if (hFindFile != INVALID_HANDLE_VALUE) {
    // nhN[Y
    // (hFindFile  INVALID_HANDLE_VALUE ȂnhN[Y
    // Kv͂ȂB)
    FindClose(hFindFile);

    // fBNgǂ`FbN
    if (ffd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
      return TRUE;
    }
  }
  return false;
}
//---------------------------------------------------------------------------
/**
 * s\`FbN
 */
bool
KCopalConfig::CheckPath(void) {

  // s\t@C邩`FbN

  if(!FileExists(GetExePath())) {
    ShowMessage("File "+ GetExePath() +" is not found.");
    return false;
  }

  //spfBNg邩`FbN

  AnsiString Dir = ExtractFileDir(GetTempFile());

  if(!isDirectoryExists(Dir.c_str())) {
    ShowMessage("Temp Directory "+ Dir +" is not found.");
    return false;
  }
  return true;
}
//---------------------------------------------------------------------------
/**
 * O猾ւ̃|C^𓾂
 */
void
KCopalConfig::SearchByName(AnsiString LangName) {
  for(int i=0;i<GetDefConfigCount();i++) {
    KDefConfig *df = GetDefConfigAt(i);
    if(df->LangName.LowerCase()==LangName.LowerCase()) {
      ChangeLanguage(df);
      return;
    }
  }
}
//---------------------------------------------------------------------------
/**
 * t@CtB^[̍쐬
 */
AnsiString
KCopalConfig::GetFileFilter(void) {
  TStringList *st1 = new TStringList;
  st1->CommaText = CurrentLanguage->LangExt;

  AnsiString as1 = CurrentLanguage->LangName + " Files(";
  for(int i=0;i<st1->Count;i++) {
    if(i!=0)
      as1+=",";
    as1+="*.";
    as1+=st1->Strings[i];
  }
  as1+=")|";
  for(int i=0;i<st1->Count;i++) {
    if(i!=0)
      as1+=";";
    as1+="*.";
    as1+=st1->Strings[i];
  }
  as1+= "|All Files(*.*)|*.*";
  delete st1;
  return as1;
}
//---------------------------------------------------------------------------
/**
 * gq猾𓾂
 */
bool
KCopalConfig::SearchByExt(AnsiString FileName) {
  AnsiString Ext = ExtractFileExt(FileName).Trim();

  if(CurrentLanguage->Contains(Ext)){
    return true;
  }

  for(int i=0;i<GetDefConfigCount();i++) {
    KDefConfig *df = GetDefConfigAt(i);
    if(df->Contains(Ext)){
      ChangeLanguage(df);
      return true;
    }
  }
  return false;
}
//---------------------------------------------------------------------------
/**
 * ꂪo^ĂȂ`FbN
 */
bool
KCopalConfig::LanguageExists(AnsiString LangName){
  for(int i=0;i<GetDefConfigCount();i++) {
    KDefConfig *df = GetDefConfigAt(i);
    if(df->LangName.Trim().LowerCase()==LangName.Trim().LowerCase()) {
      return true;
    }
  }
  return false;
}
//---------------------------------------------------------------------------
/**
 *
 */
void
KCopalConfig::SetTabWidth(int _TabWidth){
  TabWidth = _TabWidth;
  FScript->SetTabWidth(this,TabWidth);
}
//---------------------------------------------------------------------------
/**
 * ^uݒ肷BtHgݒ肳ꂽŌĂԂ
 */
void
KCopalConfig::SetTabWidthToRichEdit(TRichEdit *re, int w){
  PARAFORMAT f;
  int tabtwips = re->Font->Size * w * 120 / 11;
  f.cbSize = sizeof(PARAFORMAT);
  f.dwMask = PFM_TABSTOPS;
  f.cTabCount = MAX_TAB_STOPS;
  for(int i = 0;i < f.cTabCount;i++){
    f.rgxTabs[i] = (i + 1) * tabtwips;
  }
  re->Perform(EM_SETPARAFORMAT,(WPARAM)0,(LPARAM)&f);
  re->Invalidate();
}
//---------------------------------------------------------------------------
// C^tF[X
//---------------------------------------------------------------------------
/**
 * e|t@CԂ
 */
AnsiString
KCopalConfig::GetTempFile(void) {
  if(CurrentLanguage->TempDir=="") {
    return DefaultPath + CurrentLanguage->TempFile;
  } else {
    return CurrentLanguage->TempDir + "\\"+CurrentLanguage->TempFile;
  }
}
//---------------------------------------------------------------------------
void
KCopalConfig::SetHotKey(TShortCut _HotKey) {

  ATOM HotKeyID = GlobalFindAtom(HotKeyIDStr);

  if(HotKeyID == 0) {
    HotKeyID = GlobalAddAtom(HotKeyIDStr);
  }

  UINT mod = 0, key = 0;
  TShiftState ss;
  ShortCutToKey(_HotKey,(unsigned short&)key,ss);
  //CL[̐ݒ
  if (ss.Contains(ssShift)){
    mod += MOD_SHIFT;
  }
  if (ss.Contains(ssCtrl)) {
    mod += MOD_CONTROL;
  }
  if (ss.Contains(ssAlt)) {
    mod += MOD_ALT;
  }
  RegisterHotKey(FMain->Handle,(int)HotKeyID,mod,key);
}
//---------------------------------------------------------------------------
/**
 *  zbgL[폜
 */
void
KCopalConfig::UnsetHotKey(void){
  ATOM HotKeyID = GlobalFindAtom(HotKeyIDStr);
  if(HotKeyID == 0) { //zbgL[͓o^ĂȂ
    return;
  }
  UnregisterHotKey(FMain->Handle,(int)HotKeyID);
  GlobalDeleteAtom(HotKeyID);
}
//---------------------------------------------------------------------------
/**
 * zbgL[ύX
 */
void
KCopalConfig::ChangeHotKey(bool _UseHotKey, TShortCut _HotKey) {
  bUseHotKey = _UseHotKey;
  HotKey = _HotKey;
  if(bUseHotKey) {
    SetHotKey(HotKey);
  } else {
    UnsetHotKey();
  }
}
//---------------------------------------------------------------------------
/**
 * ҏW֎~ύX
 */
void
KCopalConfig::SetReadOnly(bool b) {
  ReadOnly = b;
  FScript->SetReadOnly(b);
}
//---------------------------------------------------------------------------
/**
 * R[h[hԂ
 */
int
KCopalConfig::GetCodeMode(void){
  return DefaultCode;
}
//---------------------------------------------------------------------------
/**
 * R[h[hݒ肷
 */
void
KCopalConfig::SetCodeMode(int _CodeMode){
  DefaultCode = _CodeMode;
  FScript->SetCode(DefaultCode);
}
//---------------------------------------------------------------------------
/**
 * R[h\镶Ԃ
 */
char *
KCopalConfig::GetCodeStr(void) {
  return KCodeConv::GetCodeChar(DefaultCode);
}
//---------------------------------------------------------------------------

