//---------------------------------------------------------------------------
#include <vcl.h>
#include "Main.h"
#pragma hdrstop
USEFORM("Main.cpp", FMain);
USEFORM("Base.cpp", FBase);
USEFORM("Script.cpp", FScript);
USEFORM("Result.cpp", FResult);
USEFORM("StdError.cpp", FStdError);
USEFORM("Version.cpp", FVersion);
USEFORM("LangConfig.cpp", FLangConfig);
USEFORM("Config.cpp", FConfig);
USEFORM("NewLang.cpp", FNewLang);
USEFORM("Dummy.cpp", FCopalProMain);
USEFORM("OpenDir.cpp", FOpenDir);
USEFORM("Editor.cpp", FEditor);
USEFORM("OpenFile.cpp", FOpenFile);
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR lpCmdLine, int) {

  //fBNg񂪖JgfBNg擾
  AnsiString FileName = lpCmdLine;
  if (FileName != "" && ExtractFileDir(FileName)=="") {
    FileName = GetCurrentDir() + "\\"+FileName;
  }

  FileName = FileName.Trim();
  //t@C""ň͂܂Ă폜B
  if(FileName.Length() > 2 && FileName.AnsiPos("\"")!=0) {
    FileName = FileName.SubString(2,FileName.Length()-2);
  }

  //d풓̋֎~
  CreateMutex(NULL, TRUE, "CopalProMutex");
  DWORD err = GetLastError();

  if (err == ERROR_ALREADY_EXISTS) {
    //łɏ풓Ă炻ɃbZ[W𓊂āA͎
    HWND prev = FindWindow("TFCopalProMain",NULL);
    if(prev!=NULL) {
      //Global AtomƂĒǉ
      ATOM atom = GlobalAddAtom(FileName.c_str());
      if (PostMessage(prev,WM_FILEPOST,(int)atom,0)==0) {
        MessageBox(NULL,"Posting Message was failed.","CopalPro",MB_OK);
      }
      return 0;
    }else {
    //mutexݒ肳Ă̂ɃEBhEȂ(I̋^)
    const char *msg = "OAɏIĂȂ\܂B\n"
    "PerlȂǂ̃vZXcĂ\܂̂ŁA\n"
    "^XN}l[W폜悤ɂĂB\n"
    "܂AȂׂIAGXP[vL[𗘗p悤\n"
    "ĂB";
    MessageBox(NULL,msg,"CopalPro",MB_OK);
    }
  }
  try {
    Application->Initialize();
    Application->Title = "Copal 2";
    Application->CreateForm(__classid(TFMain), &FMain);
                 Application->CreateForm(__classid(TFBase), &FBase);
                 Application->CreateForm(__classid(TFScript), &FScript);
                 Application->CreateForm(__classid(TFResult), &FResult);
                 Application->CreateForm(__classid(TFStdError), &FStdError);
                 Application->CreateForm(__classid(TFLangConfig), &FLangConfig);
                 Application->CreateForm(__classid(TFConfig), &FConfig);
                 Application->CreateForm(__classid(TFNewLang), &FNewLang);
                 Application->CreateForm(__classid(TFCopalProMain), &FCopalProMain);
                 Application->CreateForm(__classid(TFOpenDir), &FOpenDir);
                 Application->CreateForm(__classid(TFOpenFile), &FOpenFile);
                 Application->CreateForm(__classid(TFEditor), &FEditor);
                 FMain->Init(FileName);
    Application->Run();
  } catch (Exception &exception) {
    Application->ShowException(&exception);
  }
  return 0;
}
//---------------------------------------------------------------------------
