//---------------------------------------------------------------------------
#ifndef EditorH
#define EditorH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Grids.hpp>
#include <ComCtrls.hpp>
//---------------------------------------------------------------------------
#include "KExecProc.h"
#include <Menus.hpp>
//---------------------------------------------------------------------------
//ϐf[^
class KEnvData {
private:
  AnsiString Name;
  AnsiString Value;
public:
  KEnvData(AnsiString n,AnsiString v) {
    Name=n;
    Value=v;
  };

  AnsiString GetName(void) {
    return Name;
  };
  AnsiString GetValue(void) {
    return Value;
  };
  void SetName(AnsiString n) {
    Name = n;
  };
  void SetValue(AnsiString v) {
    Value = v;
  };
};
//---------------------------------------------------------------------------
//tH[f[^
class KFormData {
private:
  int Type;
  AnsiString Name;
  AnsiString Value;
public:
  KFormData(int t,AnsiString n,AnsiString v) {
    Type = t;
    Name=n;
    Value=v;
  };
  int GetType(void) {
    return Type;
  };
  AnsiString GetName(void) {
    return Name;
  };
  AnsiString GetValue(void) {
    return Value;
  };
  void SetType(int t) {
    Type = t;
  };
  void SetName(AnsiString n) {
    Name = n;
  };
  void SetValue(AnsiString v) {
    Value = v;
  };
};
//---------------------------------------------------------------------------
//NbL[f[^
class KCookieData {
private:
  AnsiString asName;
  AnsiString asValue;
  AnsiString asExpires;
  AnsiString asDomain;
  AnsiString asPath;
  bool bSecure;

public:
  KCookieData(AnsiString _Name, AnsiString _Value, AnsiString _Expires,
              AnsiString _Domain, AnsiString _Path, bool _Secure) {
    asName = _Name;
    asValue = _Value;
    asExpires = _Expires;
    asDomain = _Domain;
    asPath   = _Path;
    bSecure = _Secure;
  };
  AnsiString GetName(void) {
    return asName;
  };
  AnsiString GetValue(void) {
    return asValue;
  };
  AnsiString GetExpires(void) {
    return asExpires;
  };
  AnsiString GetDomain(void) {
    return asDomain;
  };
  AnsiString GetPath(void) {
    return asPath;
  };
  bool GetSecure(void) {
    return bSecure;
  };

  void SetName(AnsiString as)   {
    asName    = as;
  };
  void SetValue(AnsiString as)  {
    asValue   = as;
  };
  void SetExpires(AnsiString as) {
    asExpires = as;
  };
  void SetDomain(AnsiString as) {
    asDomain  = as;
  };
  void SetPath(AnsiString as)   {
    asPath    = as;
  };
  void SetSecure(bool b)        {
    bSecure   = b;
  };
};
//---------------------------------------------------------------------------
enum F_TYPE{FT_TEXT,FT_TEXTAREA,FT_CHECKBOX};//tH[f[^̃^Cv
enum F_METHOD{FM_GET,FM_POST};//tH[REQUEST_METHOD

//---------------------------------------------------------------------------
class TFEditor : public TForm {
__published:	// IDE Ǘ̃R|[lg
  TPageControl *PageControl1;
  TTabSheet *TbEnvironmentData;
  TTabSheet *TbFormData;
  TStringGrid *SgFormData;
  TPanel *Panel1;
  TPageControl *PCFormData;
  TTabSheet *TbText;
  TLabel *Label3;
  TLabel *Label4;
  TEdit *EdTextName;
  TEdit *EdTextValue;
  TTabSheet *TbTextarea;
  TLabel *Label5;
  TLabel *Label6;
  TEdit *EdTextareaName;
  TMemo *MemoTextarea;
  TTabSheet *TbCheckbox;
  TLabel *Label7;
  TEdit *EdCheckboxName;
  TCheckBox *CbCheckboxValue;
  TButton *BtAddForm;
  TButton *BtRemoveForm;
  TStringGrid *SgEnvData;
  TPanel *Panel2;
  TButton *BtAddEnv;
  TButton *BtRemoveEnv;
  TComboBox *CbEnvName;
  TLabel *Label1;
  TLabel *Label2;
  TEdit *EdEnvValue;
  TButton *BtFormClear;
  TButton *BtEnvClear;
  TMainMenu *MainMenu1;
  TMenuItem *C1;
  TMenuItem *METHOD1;
  TMenuItem *MMGET;
  TMenuItem *MMPOST;
  TMenuItem *C2;
  TMenuItem *MMSJIS;
  TMenuItem *MMEUC;
  TMenuItem *Edit1;
  TMenuItem *MMCopy;
  TMenuItem *MMCut;
  TMenuItem *MMPaste;
  TMenuItem *MMStayOnTop;
  TTabSheet *TabSheet1;
  TPanel *Panel3;
  TStringGrid *SgCookieData;
  TEdit *EdCookieName;
  TEdit *EdCookieValue;
  TEdit *EdCookieExpires;
  TEdit *EdCookieDomain;
  TEdit *EdCookiePath;
  TCheckBox *CBCookieSecure;
  TLabel *Label8;
  TLabel *Label9;
  TLabel *Label10;
  TLabel *Label11;
  TLabel *Label12;
  TButton *BtAddCookie;
  TButton *BtRemoveCookie;
  TButton *BtClearCookie;
  void __fastcall FormDestroy(TObject *Sender);
  void __fastcall BtAddEnvClick(TObject *Sender);
  void __fastcall SgEnvDataClick(TObject *Sender);
  void __fastcall BtRemoveEnvClick(TObject *Sender);
  void __fastcall EdEnvValueKeyPress(TObject *Sender, char &Key);
  void __fastcall CbEnvNameKeyPress(TObject *Sender, char &Key);
  void __fastcall BtAddFormClick(TObject *Sender);
  void __fastcall SgFormDataClick(TObject *Sender);
  void __fastcall BtRemoveFormClick(TObject *Sender);
  void __fastcall EdTextNameKeyPress(TObject *Sender, char &Key);
  void __fastcall EdTextValueKeyPress(TObject *Sender, char &Key);
  void __fastcall EdTextareaNameKeyPress(TObject *Sender, char &Key);
  void __fastcall EdCheckboxNameKeyPress(TObject *Sender, char &Key);
  void __fastcall CbCheckboxValueKeyPress(TObject *Sender,
                                          char &Key);
  void __fastcall BtFormClearClick(TObject *Sender);
  void __fastcall BtEnvClearClick(TObject *Sender);
  void __fastcall MMGETClick(TObject *Sender);
  void __fastcall MMPOSTClick(TObject *Sender);
  void __fastcall MMSJISClick(TObject *Sender);
  void __fastcall MMEUCClick(TObject *Sender);
  void __fastcall MMCopyClick(TObject *Sender);
  void __fastcall MMCutClick(TObject *Sender);
  void __fastcall MMPasteClick(TObject *Sender);
  void __fastcall FormKeyPress(TObject *Sender, char &Key);
  void __fastcall MMStayOnTopClick(TObject *Sender);
  void __fastcall BtAddCookieClick(TObject *Sender);
  void __fastcall SgCookieDataClick(TObject *Sender);
  void __fastcall BtRemoveCookieClick(TObject *Sender);
  void __fastcall BtClearCookieClick(TObject *Sender);
  void __fastcall EdCookieNameKeyPress(TObject *Sender, char &Key);
  void __fastcall EdCookieValueKeyPress(TObject *Sender, char &Key);
  void __fastcall EdCookieDomainKeyPress(TObject *Sender, char &Key);
  void __fastcall EdCookiePathKeyPress(TObject *Sender, char &Key);
  void __fastcall EdCookieExpiresKeyPress(TObject *Sender,
                                          char &Key);
private:	// [U[錾

  TList *EnvList;//ϐ̃Xg
  TList *FormList;//tH[f[^̃Xg
  TList *CookieList;//Cookief[^̃Xg

  int Code;//R[h
  int Method;//POST or GET

  //ϐ֘A
  int GetEnvCount(void) {
    return EnvList->Count;
  };
  KEnvData *GetEnvData(int i) {
    return (KEnvData*)EnvList->Items[i];
  }
  ;//ϐ𓾂
  void DeleteEnv(int i);//ϐ̍폜
  void DeleteEnvAll(void) {
    while(GetEnvCount()!=0)
      DeleteEnv(0);
  };
  void AddEnvData(AnsiString Name, AnsiString Value);
  int CheckEnvData(AnsiString Name);
  void EnvClear(void);
  void ShowEnvData(void);

  //tH[f[^֘A
  int GetFormCount(void) {
    return FormList->Count;
  };
  KFormData *GetFormData(int i) {
    return (KFormData*)FormList->Items[i];
  };
  void DeleteForm(int i);
  void DeleteFormAll(void) {
    while(GetFormCount()!=0)
      DeleteForm(0);
  };
  void AddFormData(int Type, AnsiString Name, AnsiString Value);
  int CheckFormData(AnsiString Name);
  AnsiString MakeURLEncodedText(void);
  void ShowFormData(void);
  void FormClear(void);

  //Cookie֘A
  int GetCookieCount(void) {
    return CookieList->Count;
  };
  void DeleteCookie(int i);
  void DeleteCookieAll(void) {
    while(GetCookieCount()!=0)
      DeleteCookie(0);
  };
  KCookieData *GetCookieData(int i) {
    return (KCookieData*)CookieList->Items[i];
  };
  int CheckCookieData(AnsiString Name);
  void AddCookieData(AnsiString _Name, AnsiString _Value, AnsiString _Expires,
                     AnsiString _Domain, AnsiString _Path, bool _Secure);
  void CookieClear(void);
  void ShowCookieData(void);
  AnsiString GetCookieText(void);


  bool mStayOnTop;

public:		// [U[錾

  void GetCGIData(KExecProc *ep);//CGIf[^󂯓n
  int GetRequestMethod(void) {
    return Method;
  };

  void SetStayOnTop(bool b);
  bool isStayOnTop(void);

  __fastcall TFEditor(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TFEditor *FEditor;
//---------------------------------------------------------------------------
#endif
