/**
 *
 */
#if !defined(COOLRAIN__TAGSET__H__)
#define COOLRAIN__TAGSET__H__


#include <glib/ghash.h>
#include <glib/gmacros.h>

#include <CoolRain/error.h>
#include <CoolRain/thread.h>
#include <CoolRain/refstring.h>
#include <CoolRain/stash.h>
#include <CoolRain/writer.h>

G_BEGIN_DECLS;

struct coolrain_fragment;
struct coolrain_template;
struct coolrain_eval_context;


typedef int (*coolrain_tag_handler_t)(struct coolrain_eval_context const *cntx);

struct coolrain_tag_desc {
	coolrain_refstring_t	name;
	coolrain_tag_handler_t	handler;
	unsigned int		flags;
};

#define COOLRAIN_TAG_DESC_FLAGS_ALLOCED		(1 << 0)
#define COOLRAIN_TAG_DESC_FLAGS_HAS_ELSE_BLOCK	(1 << 1)



struct coolrain_filter_desc {
	coolrain_refstring_t		name;
	coolrain_writer_write_handler_t handler;
	unsigned int			flags;
};

#define COOLRAIN_FILTER_DESC_FLAGS_ALLOCED      (1 << 0)


struct coolrain_tagset {
	coolrain_mutex_t	 mutex;
	GHashTable		*tags;
	GHashTable		*filters;
};




/*
 *
 */
int	coolrain_tagset_initialize(struct coolrain_tagset *tagset);
void	coolrain_tagset_destroy(struct coolrain_tagset *taget);


/* !{ @name Tag handler */
int coolrain_tagset_add_tag(
	struct coolrain_tagset		*tagset,
	char const*			 name,
	coolrain_tag_handler_t		 handler,
	unsigned int			 flags);
int coolrain_tagset_register_tags(
	struct coolrain_tagset		*tagset,
	struct coolrain_tag_desc	*table);
struct coolrain_tag_desc const *coolrain_tagset_lookup_tag(
	struct coolrain_tagset		*tagset,
	coolrain_refstring_t const	*name);

extern struct coolrain_tag_desc coolrain_tagset_default_tags[];
extern struct coolrain_tag_desc coolrain_tagset_gkeyfile_tags[];
/* !} */

/* !{ @name Filter handler */
int coolrain_tagset_add_filter(
	struct coolrain_tagset		*tagset,
	char const			*name,
	coolrain_filter_handler_t	 handler,
	unsigned int			 flags);
int coolrain_tagset_register_filters(
	struct coolrain_tagset		*tagset,
	struct coolrain_filter_desc	*table);
struct coolrain_filter_desc const *coolrain_tagset_lookup_filter(
	struct coolrain_tagset		*tagset,
	coolrain_refstring_t const	*name);

extern struct coolrain_filter_desc coolrain_tagset_default_filters[];
/* !} */


/* !{ @name Built-in tag handler */
int coolrain_builtin_tag_handler_ignore(struct coolrain_eval_context const *cntx);
#define coolrain_builtin_tag_handler_pass	coolrain_template_eval_content
int coolrain_builtin_tag_handler_let(struct coolrain_eval_context const *cntx);
int coolrain_builtin_tag_handler_var(struct coolrain_eval_context const *cntx);
int coolrain_builtin_tag_handler_loop(struct coolrain_eval_context const *cntx);
int coolrain_builtin_tag_handler_include(struct coolrain_eval_context const *cntx);
int coolrain_builtin_tag_handler_include_param(struct coolrain_eval_context const *cntx);
/* !} */


struct coolrain_stash_value_list *coolrain_gkeyfile_setup(
	struct coolrain_stash *stash,
	char const *path,
	char const *locale);
void coolrain_gkeyfile_restore(
	struct coolrain_stash *stash,
	struct coolrain_stash_value_list *vl);

G_END_DECLS;

#endif

