/**
 * \par Threading:
 * The stash object is no thread safe.
 */
#if !defined(COOLRAIN__STASH__H__)
#define COOLRAIN__STASH__H__

#include <glib/gtypes.h>
#include <glib/ghash.h>
#include <glib/gmacros.h>
#include <glib/gslist.h>

#include <CoolRain/thread.h>
#include <CoolRain/error.h>
#include <CoolRain/variant.h>

G_BEGIN_DECLS;

/**
 *
 */
typedef int (*coolrain_stash_lookup_handler_t)(coolrain_variant_t * __restrict value, coolrain_refstring_t const * __restrict key);

struct coolrain_stash {
	coolrain_mutex_t	mutex;
	GHashTable		*hash;
	GSList			*context_stack;
	coolrain_stash_lookup_handler_t lookup_handler;
	GSList			*alloced_values;
};



int coolrain_stash_initialize(struct coolrain_stash *stash);
void coolrain_stash_destroy(struct coolrain_stash *stash);



coolrain_variant_t const *coolrain_stash_get_value(struct coolrain_stash * __restrict stash, coolrain_refstring_t const * __restrict key);

static inline coolrain_variant_t const *coolrain_stash_get_value_(struct coolrain_stash * __restrict stash, char const * __restrict key)
{
	coolrain_refstring_t k;
	k.begin = key;
	k.end = NULL;
	coolrain_refstring_fix(&k);
	return coolrain_stash_get_value(stash, &k);
}




struct coolrain_stash_value_list {
	coolrain_refstring_t		name;
	coolrain_variant_t		value;
	coolrain_variant_t const	*old_value;
};
#define COOLRAIN_STASH_VALUE_INITIALIZER { { NULL, NULL }, COOLRAIN_VARIANT_INITIALIZER, NULL }

void coolrain_stash_set_values(struct coolrain_stash * __restrict stash, struct coolrain_stash_value_list * __restrict values, size_t count);
void coolrain_stash_restore(struct coolrain_stash * __restrict stash, struct coolrain_stash_value_list * __restrict values, size_t count);


static inline void coolrain_stash_set_lookup_handler(struct coolrain_stash * __restrict stash, coolrain_stash_lookup_handler_t handler)
{
	stash->lookup_handler = handler;
}


void coolrain_stash_value_list_unset(struct coolrain_stash_value_list * __restrict values, size_t count);


G_END_DECLS;

#endif

