/*
 * The MIT License

   Conograph (powder auto-indexing program)

Copyright (c) <2012> <Ryoko Oishi-Tomiyasu, KEK>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 *
 */
#include "../zerror_type/error_out.hh"
#include "putXYZ_str_s1.hh"

const XYZCoord<StringS1>& putXYZ()
{
	static const XYZCoord<StringS1> xyz( StringS1::putX(), StringS1::putY(), StringS1::putZ() );
	return xyz;
}

XYZCoord<StringS1> putXYZ(const VecDat3<Double>& pos, const Mat_DP_constr& pos_constr)
{
	static const UInt4 dim = 3;
	assert( pos_constr.size() == dim );

	VecDat3<StringS1> ans;
	Double const_term;
	for(UInt4 k=0; k<dim; k++)
		if( pos_constr[k].ID == _ZRietveldIDVary ){
			if(k==0) ans[0] = StringS1::putX();
			else if(k==1) ans[1] = StringS1::putY();
			else ans[2] = StringS1::putZ();
		}
		else{
			VecDat3<Double> tray=0.0;
			const_term = pos[k];
			if( pos_constr[k].ID == _ZRietveldIDDepend )
			{
				for(UInt4 l=0; l<pos_constr[k].constr.size(); l++)
				{
					tray[pos_constr[k].constr[l].index] += pos_constr[k].constr[l].element;
					const_term -= pos[pos_constr[k].constr[l].index] * pos_constr[k].constr[l].element;
				}
			}
			StringS1 str_s1(tray, const_term); 
			ans[k] = str_s1;
		} 
	
	return XYZCoord<StringS1>(ans[0],ans[1],ans[2]);
}
