/*
 * The MIT License

   Conograph (powder auto-indexing program)

Copyright (c) <2012> <Ryoko Oishi-Tomiyasu, KEK>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 *
 */
#include"point_gp_data.hh"

// static const Int4 Max_Length = 7;

typedef struct{
	string schonflies_symbol;
	string HermannMauguin_symbol;
	Int4 order;
	ePointGroup elaue_gp;
} point_gp;

static const point_gp& change_enum_to_data(const ePointGroup& epg)
{
	static const Int4 ISIZE = 141;
	static const point_gp point_gp_data[ISIZE] = {
		{ "C1","1",1,Ci },
		{ "Ci","-1",2,Ci },
		{ "C2(a-axis)","2(a-axis)",2,C2h_X },
		{ "C2(b-axis)","2(b-axis)",2,C2h_Y },
		{ "C2(c-axis)","2(c-axis)",2,C2h_Z },
//		{ "C2(c-axis)","2(c-axis)",2,C2h_hex },
		{ "C2","2",2,C2hD_X0_rho },
		{ "C2","2",2,C2hD_X1_rho },
		{ "C2","2",2,C2hD_Y0_rho },
		{ "C2","2",2,C2hD_Y1_rho },
		{ "C2","2",2,C2hD_Z0 },
		{ "C2","2",2,C2hD_Z1 },
		{ "C2","2",2,C2hD_X0_hex },
		{ "C2","2",2,C2hD_X1_hex },
		{ "C2","2",2,C2hD_Y0_hex },
		{ "C2","2",2,C2hD_Y1_hex },
//		{ "C2","2",2,C2hD_Z0_hex },
		{ "Cs(a-axis)","m(a-axis)",2,C2h_X },
		{ "Cs(b-axis)","m(b-axis)",2,C2h_Y },
		{ "Cs(c-axis)","m(c-axis)",2,C2h_Z },
//		{ "Cs(c-axis)","m(c-axis)",2,C2h_hex },
		{ "Cs","m",2,C2hD_X0_rho },
		{ "Cs","m",2,C2hD_X1_rho },
		{ "Cs","m",2,C2hD_Y0_rho },
		{ "Cs","m",2,C2hD_Y1_rho },
		{ "Cs","m",2,C2hD_Z0 },
		{ "Cs","m",2,C2hD_Z1 },
		{ "Cs","m",2,C2hD_X0_hex },
		{ "Cs","m",2,C2hD_X1_hex },
		{ "Cs","m",2,C2hD_Y0_hex },
		{ "Cs","m",2,C2hD_Y1_hex },
//		{ "Cs","m",2,C2hD_Z0_hex },
		{ "C2h(a-axis)","2/m(a-axis)",4,C2h_X },
		{ "C2h(b-axis)","2/m(b-axis)",4,C2h_Y },
		{ "C2h(c-axis)","2/m(c-axis)",4,C2h_Z },
//		{ "C2h(c-axis)","2/m(c-axis)",4,C2h_hex },
		{ "C2h","2/m",4,C2hD_X0_rho },
		{ "C2h","2/m",4,C2hD_X1_rho },
		{ "C2h","2/m",4,C2hD_Y0_rho },
		{ "C2h","2/m",4,C2hD_Y1_rho },
		{ "C2h","2/m",4,C2hD_Z0 },
		{ "C2h","2/m",4,C2hD_Z1 },
		{ "C2h","2/m",4,C2hD_X0_hex },
		{ "C2h","2/m",4,C2hD_X1_hex },
		{ "C2h","2/m",4,C2hD_Y0_hex },
		{ "C2h","2/m",4,C2hD_Y1_hex },
//		{ "C2h","2/m",4,C2hD_Z0_hex },
		{ "D2","222",4,D2h },
		{ "D2","222",4,D2hprime_X_rho },
		{ "D2","222",4,D2hprime_Y_rho },
		{ "D2","222",4,D2hprime_Z_rho },
		{ "D2","222",4,D2hprime_X_hex },
		{ "D2","222",4,D2hprime_Y_hex },
		{ "D2","222",4,D2hprime_Z_hex },
		{ "C2v(a-axis)","2mm",4,D2h },
		{ "C2v(b-axis)","m2m",4,D2h },
		{ "C2v(c-axis)","mm2",4,D2h },
		{ "C2v","mm2",4,D2hprime_X_rho },
		{ "C2v","mm2",4,D2hprime_Y_rho },
		{ "C2v","mm2",4,D2hprime_Z_rho },
		{ "C2v","mm2",4,D2hprime_X_hex },
		{ "C2v","mm2",4,D2hprime_Y_hex },
		{ "C2v","mm2",4,D2hprime_Z_hex },
		{ "C2v","mm2",4,D2hprime_X_rho },
		{ "C2v","mm2",4,D2hprime_X_rho },
		{ "C2v","mm2",4,D2hprime_Y_rho },
		{ "C2v","mm2",4,D2hprime_Y_rho },
		{ "C2v","mm2",4,D2hprime_Z_rho },
		{ "C2v","mm2",4,D2hprime_Z_rho },
		{ "C2v","mm2",4,D2hprime_X_hex },
		{ "C2v","mm2",4,D2hprime_X_hex },
		{ "C2v","mm2",4,D2hprime_Y_hex },
		{ "C2v","mm2",4,D2hprime_Y_hex },
		{ "C2v","mm2",4,D2hprime_Z_hex },
		{ "C2v","mm2",4,D2hprime_Z_hex },
		{ "D2h","mmm",8,D2h },
		{ "D2h","mmm",8,D2hprime_X_rho },
		{ "D2h","mmm",8,D2hprime_Y_rho },
		{ "D2h","mmm",8,D2hprime_Z_rho },
		{ "D2h","mmm",8,D2hprime_X_hex },
		{ "D2h","mmm",8,D2hprime_Y_hex },
		{ "D2h","mmm",8,D2hprime_Z_hex },
		{ "C3","3",3,C3i_hex },
		{ "C3","3",3,C31i_rho },
		{ "C3","3",3,C32i_rho },
		{ "C3","3",3,C33i_rho },
		{ "C3","3",3,C34i_rho },
		{ "C3i","-3",6,C3i_hex },
		{ "C3i","-3",6,C31i_rho },
		{ "C3i","-3",6,C32i_rho },
		{ "C3i","-3",6,C33i_rho },
		{ "C3i","-3",6,C34i_rho },
		{ "D3","3.2",6,D3d_0_hex },
		{ "D3","32.",6,D3d_1_hex },
		{ "D3","32",6,D31d_rho },
		{ "D3","32",6,D32d_rho },
		{ "D3","32",6,D33d_rho },
		{ "D3","32",6,D34d_rho },
		{ "C3v","3.m",6,D3d_0_hex },
		{ "C3v","3m.",6,D3d_1_hex },
		{ "C3v","3m",6,D31d_rho },
		{ "C3v","3m",6,D32d_rho },
		{ "C3v","3m",6,D33d_rho },
		{ "C3v","3m",6,D34d_rho },
		{ "D3d","-3.m",12,D3d_0_hex },
		{ "D3d","-3m.",12,D3d_1_hex },
		{ "D3d","-3m",12,D31d_rho },
		{ "D3d","-3m",12,D32d_rho },
		{ "D3d","-3m",12,D33d_rho },
		{ "D3d","-3m",12,D34d_rho },
		{ "C4(a-axis)","4(a-axis)",4,C4h_X },
		{ "C4(b-axis)","4(b-axis)",4,C4h_Y },
		{ "C4(c-axis)","4(c-axis)",4,C4h_Z },
		{ "S4(a-axis)","-4(a-axis)",4,C4h_X },
		{ "S4(b-axis)","-4(b-axis)",4,C4h_Y },
		{ "S4(c-axis)","-4(c-axis)",4,C4h_Z },
		{ "C4h(a-axis)","4/m(a-axis)",8,C4h_X },
		{ "C4h(b-axis)","4/m(b-axis)",8,C4h_Y },
		{ "C4h(c-axis)","4/m(c-axis)",8,C4h_Z },
		{ "D4(a-axis)","422",8,D4h_X },
		{ "D4(b-axis)","242",8,D4h_Y },
		{ "D4(c-axis)","224",8,D4h_Z },
		{ "C4v(a-axis)","4mm",8,D4h_X },
		{ "C4v(b-axis)","m4m",8,D4h_Y },
		{ "C4v(c-axis)","mm4",8,D4h_Z },
		{ "D2d(a-axis)","-42m",8,D4h_X },
		{ "D2d(b-axis)","-42m",8,D4h_Y },
		{ "D2d(c-axis)","-42m",8,D4h_Z },
		{ "D2d","-42m",8,D4h_X },
		{ "D2d","-42m",8,D4h_Y },
		{ "D2d","-42m",8,D4h_Z },
		{ "D4h(a-axis)","4/mmm",16,D4h_X },
		{ "D4h(b-axis)","m4/mm",16,D4h_Y },
		{ "D4h(c-axis)","mm4/m",16,D4h_Z },
		{ "C6","6",6,C6h },
		{ "C3h","-6",6,C6h },
		{ "C6h","6/m",12,C6h },
		{ "D6","622",12,D6h },
		{ "C6v","6mm",12,D6h },
		{ "D3h","-6m2",12,D6h },
		{ "D3h","-62m",12,D6h },
		{ "D6h","6/mmm",24,D6h },
		{ "T","23",12,Th },
		{ "Th","m-3",24,Th },
		{ "O","432",24,Oh },
		{ "Td","-43m",24,Oh },
		{ "Oh","m-3m",48,Oh }
	};
	return point_gp_data[Int4(epg)];
}
	

const ePointGroup& enumLaueGroup(const ePointGroup& epg)
{
	return change_enum_to_data(epg).elaue_gp;
}

const string& Name(const ePointGroup& epg)
{
	return change_enum_to_data(epg).HermannMauguin_symbol;
}

const Int4& Order(const ePointGroup& epg)
{
	return change_enum_to_data(epg).order;
}

