/*
 * The MIT License

   Conograph (powder auto-indexing program)

Copyright (c) <2012> <Ryoko Oishi-Tomiyasu, KEK>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 *
 */
#ifndef LATTICE_SYMMETRY_HH_
#define LATTICE_SYMMETRY_HH_

#include <set>
#include "../utility_data_structure/nrutil_nr.hh"
#include "../utility_data_structure/SymMat.hh"
#include "../utility_data_structure/VCData.hh"
#include "../utility_data_structure/SymMat43.hh"
#include "../utility_data_structure/FracMat.hh"

class BravaisType;


inline bool equiv_resol(const Double& lhs, const Double& rhs, 
		const Double& resol2)
{
	Double diff = lhs - rhs;
	Double max_value = max( fabs(lhs), fabs(rhs) );
	if( fabs( diff ) <= max_value * resol2 ) return true;
	return false; 
}



// Each element rhs of S_super_obtuse_equiv satisfies ( rhs * S_super_obtuse * transpose(rhs) ) are almost Selling-reduced.
void put_S_super_obtuse_equiv(const SymMat<Double>& S_super_obtuse, const Double& resol2,
		vector< SymMat<Double> >& S_super_obtuse_equiv);


inline bool check_equiv_m(const SymMat<Double>& lhs, //const Double& lhs_detS, const Double& lhs_detS_var,
		const SymMat<Double>& rhs, //const Double& rhs_detS, const Double& rhs_detS_var,
		const Double& resol2)
{
	if( !equiv_resol( lhs(0,0), rhs(0,0), resol2) )
	{
		return false;
	}
	if( !equiv_resol( lhs(1,1), rhs(1,1), resol2) )
	{
		return false;
	}
	if( !equiv_resol( lhs(2,2), rhs(2,2), resol2) )
	{
		return false;
	}
	if( !equiv_resol( lhs(0,0)+lhs(1,1)+lhs(0,1)*2.0, rhs(0,0)+rhs(1,1)+rhs(0,1)*2.0, resol2) )
	{
		return false;
	}
	if( !equiv_resol( lhs(0,0)+lhs(2,2)+lhs(0,2)*2.0, rhs(0,0)+rhs(2,2)+rhs(0,2)*2.0, resol2) )
	{
		return false;
	}
	if( !equiv_resol( lhs(1,1)+lhs(2,2)+lhs(1,2)*2.0, rhs(1,1)+rhs(2,2)+rhs(1,2)*2.0, resol2) )
	{
		return false;
	}
	return true;
}


inline bool check_equiv_m(const SymMat<VCData>& lhs, //const Double& lhs_detS, const Double& lhs_detS_var,
		const SymMat<VCData>& rhs, //const Double& rhs_detS, const Double& rhs_detS_var,
		const Double& cv2)
{
	if( !vc_equiv( lhs(0,0), rhs(0,0), cv2) ) return false;
	if( !vc_equiv( lhs(1,1), rhs(1,1), cv2) ) return false;
	if( !vc_equiv( lhs(2,2), rhs(2,2), cv2) ) return false;
	if( !vc_equiv( lhs(0,0) + lhs(1,1) + lhs(0,1)*2, rhs(0,0) + rhs(1,1) + rhs(0,1)*2, cv2) ) return false;
	if( !vc_equiv( lhs(0,0) + lhs(2,2) + lhs(0,2)*2, rhs(0,0) + rhs(2,2) + rhs(0,2)*2, cv2) ) return false;
	if( !vc_equiv( lhs(1,1) + lhs(2,2) + lhs(1,2)*2, rhs(1,1) + rhs(2,2) + rhs(1,2)*2, cv2) ) return false;

	return true;
}

#endif /*LATTICE_SYMMETRY_HH_*/
