#include <assert.h>
#include "RLog.hh"

/**
 * コンストラクタ
 */
CRLog::CRLog(void)
{
}

/**
 * コピーコンストラクタ
 */
CRLog::CRLog(const CRLog&)
{
}

/**
 * デストラクタ
 */
CRLog::~CRLog(void)
{
    clear();
}

/**
 * Singletonのインスタンス取得
 */
CRLog* CRLog::getInstance(void)
{
	static CRLog aPtr;
    return &aPtr;
};

/**
 * Listnerクラスの登録
 * @retval true 成功
 * @retval false 失敗
 * @attention 戻り値がtrueで登録されたクラスは内部で破棄します。
 * falseの場合は破棄されません。
 */
bool CRLog::append(Listner* cpPtr)            ///< [in]:登録対象インスタンス
{
	bool ans;
#ifdef _OPENMP
	#pragma omp critical
#endif
	{
		ans = getInstance()->append_(cpPtr);
	}
	return ans;
};

/**
 * Listnerクラスの削除
 * @retval true 成功
 * @retval false 失敗
 */
bool CRLog::remove(const zListnerID& cId)                    ///< [in]:クラス識別子
{
	bool ans;
#ifdef _OPENMP
	#pragma omp critical
#endif
	{
		ans = getInstance()->remove_(cId);
	}
	return ans;
};

/**
 * 登録クラスの全削除
 */
void CRLog::clear(void)
{
#ifdef _OPENMP
	#pragma omp critical
#endif
	{
		getInstance()->clear_();
	}
};

/**
 * メッセージの送信
 */
void CRLog::log(const zLevel& cLevel,                 ///< [in]:レベル
    const string& cpStr)         ///< [in]:メッセージ文字列
{
    for(vector<Listner*>::iterator i=m_ListnerAry.begin(); i != m_ListnerAry.end(); ++i)
    {
        (*i)->log(cLevel, cpStr);
    }
};

/**
 * メッセージの送信
 */
void CRLog::log(const zLevel& cLevel,                 ///< [in]:レベル
    const int& threadID,        ///< [in]:メッセージ文字列
    const string& cpStr)         ///< [in]:メッセージ文字列
{
    for(vector<Listner*>::iterator i=m_ListnerAry.begin(); i != m_ListnerAry.end(); ++i)
    {
        (*i)->log(cLevel, threadID, cpStr);
    }
};

/**
 * Listnerクラスの登録
 * @retval true 成功
 * @retval false 失敗
 * @see CRLog::append
 */
bool CRLog::append_(Listner* cpPtr)            ///< [in]:登録対象インスタンス
{
	const zListnerID aId = cpPtr->putId();
    for(vector<Listner*>::iterator i =m_ListnerAry.begin(); i != m_ListnerAry.end(); ++i)
    {
        if( (*i)->putId() == aId ) return false;
    }
    m_ListnerAry.push_back(cpPtr);
    return true;
};

/**
 * Listnerクラスの削除
 * @retval true 成功
 * @retval false 失敗
 * @see CRLog::remove
 */
bool CRLog::remove_(const zListnerID& cId) ///< [in]:クラス識別子
{
    for(vector<Listner*>::iterator i=m_ListnerAry.begin(); i!=m_ListnerAry.end(); ++i)
    {
        if( (*i)->putId() == cId )
        {
            delete *i;
            m_ListnerAry.erase(i);
            return true;
        }
    }
    return false;
};

/**
 * Listnerクラスの削除
 * @retval true 成功
 * @retval false 失敗
 * @see CRLog::clear
 */
void CRLog::clear_(void)
{
    for(vector<Listner*>::iterator i=m_ListnerAry.begin();i!=m_ListnerAry.end(); ++i)
    {
        delete *i;
    }
    m_ListnerAry.clear();
};
