/*
 * The MIT License

   BLDConograph (Bravais lattice determination module in Conograph)

Copyright (c) <2012> <Ryoko Oishi-Tomiyasu, KEK>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 *
 */
#ifndef SYMMAT43_HH_
#define SYMMAT43_HH_

#include "../utility_data_structure/SymMat.hh"

// Assume the first element is a symmetric matrix of size 3 and the second element is a 4-by-3 matrix.
typedef pair< SymMat<Double>, NRMat<Int4> > SymMat43_Double;

inline bool operator<(const SymMat<Double>& lhs, const SymMat<Double>& rhs)
{
	assert( lhs.size() >= 3 );
	assert( rhs.size() >= 3 );

	for(Int4 i=0; i<3; i++)
		for(Int4 j=i; j<3; j++)
		{
			if( lhs(i,j) < rhs(i,j) ) return true;
			if( lhs(i,j) > rhs(i,j) ) return false;
		}
	return false;
};

#endif /*SYMMAT43_HH_*/
