/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.test;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;

import jp.co.connectone.eai.exchews.store.*;
import jp.co.connectone.eai.exchews.user.*;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.user.*;
import junit.framework.TestCase;
/**
 * @author amanot
 *
 */
public class TestExchewsMemoImpl extends TestCase {
	private ExchewsMemoStoreImpl memoStore;
	private ExchewsAccountData acc = null;
	/* ( Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		memoStore = new ExchewsMemoStoreImpl();
		ExchewsServiceInfo info = (ExchewsServiceInfo)memoStore.getServiceInfo();
		IUserKey uid = new BasicUserKey(String.class.getName(), "test");
		info.setServerAddress("exchange");
		info.setProtocolPrefix("http://");
		acc = new ExchewsAccountData(uid, info);
		acc.setUserID("test");
		acc.setPassword("********");
		acc.setDomain("TEST");
	}
	/* ( Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		memoStore = null;
	}

	public void testCreateNewMemo() throws Exception
	{
		assertNotNull(memoStore);
		IMemoDTO memo = new ExchewsMemoDTO();
		memo.setSenderName("test@amax.co.jp");
		memo.setBody("ڂł[ł񂪂ȁB");
		memo.setSubject("薼");
		
		IObjectIndex oid = memoStore.createNewMemo(acc,memo);
		assertNotNull(oid);
		Log.debug(oid.toString());
	}
	
	public void testUpdateMemo() throws Exception
	{
		assertNotNull(memoStore);
		IMemoDTO memo = new ExchewsMemoDTO();
		memo.setSenderName("test@amax.co.jp");
		memo.setBody("ڂł[ł񂪂ȁB");
		memo.setSubject("updateeXgp");
		boolean catchException=false;
		try {
			memoStore.updateMemo(acc, memo);
		}
		catch (Exception e) {
			catchException=true;
		}
		finally {
			assertTrue(catchException);
		}
		catchException=false;
		
		IObjectIndex oid = memoStore.createNewMemo(acc,memo);
		assertNotNull(oid);
		memo.setOid(oid);
		
		memo.setBody("updateꂽ{fB[łB");
		
		try {
			memoStore.updateMemo(acc, memo);
		}
		catch (Exception e) {
			catchException=true;
		}
		finally {
			assertFalse(catchException);
		}
		
		IMemoDTO memo2 = memoStore.getMemoByOID(acc, oid);
		assertEquals(memo2.getSubject(), "updateeXgp");
		assertEquals(memo2.getBody(), "updateeXgp\nupdateꂽ{fB[łB");
		
	}

	public void testGetMemos() throws Exception
	{
		assertNotNull(memoStore);
		IMemoDTO[] h = memoStore.getAllMemos(acc);
		assertNotNull(h);
		assertTrue(h.length>0);
		assertFalse(h[0].isNew());
		for (int i=0;i<h.length;i++) {
			dumpDTO(h[i]);
		}
	}
	
	public void testDeleteMemo() throws Exception
	{
		String id = "AAMkADFhNGI3N2Q0LWRkNWItNDBhNy04ODIyLWUyMjYxNGU1MzE2ZgBGAAAAAAByYJ+pxeduSYit4EQVkQLFBwDAyRCo9hqpT60LcrpLV3HzAAALPsNzAAAOvrSTFzPIQ5PjycGgMJFGAGwwSN5jAAA=";		
		ExchewsObjectIndex oid = ExchEWSTranslator.createIndex(id);
		assertNotNull(memoStore);
		boolean catchException=false;
		try {
			memoStore.deleteMemo(acc, oid);
		}
		catch (IncorrectData icd) {
			catchException=true;
		}
		finally {
			assertTrue(catchException);
		}
		catchException=false;
		IMemoDTO memo = new ExchewsMemoDTO();
		memo.setSenderName("test@amax.co.jp");
		memo.setBody("ڂł[fXiB");
		memo.setSubject("폜eXgp");
		
		IObjectIndex idForDelete = memoStore.createNewMemo(acc,memo);
		try {
			memoStore.deleteMemo(acc, idForDelete);
		}
		catch (IncorrectData icd) {
			catchException=true;
		}
		finally {
			assertFalse(catchException);
		}

	}
	
	public void testGetMemo() throws Exception
	{
		String id = "AAMkADFhNGI3N2Q0LWRkNWItNDBhNy04ODIyLWUyMjYxNGU1MzE2ZgBGAAAAAAByYJ+pxeduSYit4EQVkQLFBwDAyRCo9hqpT60LcrpLV3HzAAALPsNzAAC994qxD0rdTLqAc+xnPTyTAAANdmoBAAA=";
		ExchewsObjectIndex oid = ExchEWSTranslator.createIndex(id);
		assertNotNull(memoStore);
		ExchewsMemoDTO memo = (ExchewsMemoDTO)memoStore.getMemoByOID(acc, oid);
		assertNotNull(memo);
		assertNotNull(memo.getBody());
		assertTrue(memo.getBody().length()>0);
		assertFalse(memo.isNew());
		assertTrue(memo instanceof ExchewsMemoDTO);
		dumpDTO(memo);
	}
	
	private void dumpDTO(IMemoDTO dto)
	{
		Log.debug("============================");
		Log.debug("oid:"+((ItemIdType)dto.getOid().getIndex()).getId());
		Log.debug(dto.getSubject());
		Log.debug(dto.getBody());
		Log.debug(dto.getSenderName());
	}
}
