/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.test;

import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.*;

import jp.co.connectone.eai.exchews.ews.EWSSearchFormula;
import jp.co.connectone.eai.exchews.store.*;
import jp.co.connectone.eai.exchews.user.*;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.service.*;
import jp.co.connectone.store.*;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.user.*;
import junit.framework.TestCase;
import jp.co.connectone.log.Log;

public class TestExchewsMailStoreImpl extends TestCase
{
	private ExchewsAccountData acc = null;
	private ExchewsServiceInfo info = null;
	private ExchewsMailStoreImpl store = null;
	private Date date = null;//test date definition for xxxByDate
	private String mailid = "AAMkADFhNGI3N2Q0LWRkNWItNDBhNy04ODIyLWUyMjYxNGU1MzE2ZgBGAAAAAAByYJ+pxeduSYit4EQVkQLFBwDAyRCo9hqpT60LcrpLV3HzAAALPsy+AAAOvrSTFzPIQ5PjycGgMJFGAGwwQlbUAAA=";
	private String fwdMailId="AAMkADFhNGI3N2Q0LWRkNWItNDBhNy04ODIyLWUyMjYxNGU1MzE2ZgBGAAAAAAByYJ+pxeduSYit4EQVkQLFBwDAyRCo9hqpT60LcrpLV3HzAAALPsy+AAAOvrSTFzPIQ5PjycGgMJFGAH6mGsECAAA=";

	protected void setUp() throws Exception
	{
		date = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse("2010-07-06 00:00:00");
		store = new ExchewsMailStoreImpl();
		IUserKey uid = new BasicUserKey(String.class.getName(), "test");
		info = (ExchewsServiceInfo) store.getServiceInfo();
		info.setServerAddress("172.16.3.1");
		info.setProtocolPrefix("http://");
		acc = new ExchewsAccountData(uid, info);
		acc.setUserID("testr");
		acc.setPassword("Password");
		acc.setDomain("Test2010.local");
	}

	public void testGetFolderList() throws Exception
	{
		ISearchDestination dest = store.getPresetDestination(acc, IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER);
		FolderMetadata[] folders = store.getFolderList(acc, dest);
		assertNotNull(folders);
		Log.info("no of folders:" + folders.length);
		for (FolderMetadata folder : folders) {
			Log.info("folder name:" + folder.getFolderName());
		}
	}

	public void testDeleteMail() throws Exception
	{

	}

	public void testGetHeaders() throws Exception
	{

	}

	public void teXstGetHeadersByDate() throws Exception
	{
		assertNotNull(store);
		IMailDTO[] h = store.getHeadersByDate(acc,store.getPresetDestination(acc,IMailStore.DEST_TYPE_SENT_FOLDER),date);
		assertNotNull(h);
		assertTrue(h.length>0);
		assertFalse(h[0].isNew());
		for (int i=0;i<h.length;i++) {
			dumpDTO(h[i]);
		}
	}

	public void testGetMail() throws Exception
	{
		ISearchDestination dest = store.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER);
		ExchewsObjectIndex oid = ExchEWSTranslator.createIndex(mailid);
		assertNotNull(store);
		IMailDTO mail = store.getMail(acc, dest, oid);
		assertNotNull(mail);
		assertNotNull(mail.getBody());
		assertTrue(mail.getBody().length()>0);
		assertFalse(mail.isNew());
		assertTrue(mail instanceof ExchewsMailDTO);
		HeaderDTO header = mail.getHeader();
		assertNotNull(header);
		assertNotNull(header.getHeaderFrom());
		assertNotNull(header.getHeaderSendDate());
		dumpDTO(mail);
		dumpHeader(header);
	}

	public void teXstGetMailFolders() throws Exception
	{
		ISearchDestination dest = store.getPresetDestination(acc, IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER);
		FolderMetadata[] folders = store.getMailFolders(acc, dest);
		assertNotNull(folders);
		Log.info("no of folders:" + folders.length);
		for (FolderMetadata folder : folders) {
			Log.info("folder name:" + folder.getFolderName());
		}
	}
/*
	public void testGetMailsByDate() throws Exception
	{
		assertNotNull(store);
		IMailDTO[] h = store.getMailsByDate(acc,store.getPresetDestination(acc,info,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),date);
		assertNotNull(h);
		assertTrue(h.length>0);
		assertFalse(h[0].isNew());
		for (int i=0;i<h.length;i++) {
			dumpDTO(h[i]);
		}
	}
*/
	public void testGetMailsByDate() throws Exception
	{
		assertNotNull(store);
		ISearchDestination dest = store.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER);
		SearchConditionCollection cond = null;
		List<String> fieldsToGet = ExchewsMailStoreImpl.SEARCH_FIELDS_HEADERS;
		EWSSearchFormula form = new EWSSearchFormula(dest, fieldsToGet, cond);
		IMailDTO[] h = store.getMailsByDate(acc,form,date);
		assertNotNull(h);
		assertTrue(h.length>0);
		assertFalse(h[0].isNew());
		for (int i=0;i<h.length;i++) {
			dumpDTO(h[i]);
		}
	}

	public void testGetSentMails() throws Exception
	{

	}

	public void testGetSentMailsByDate() throws Exception
	{

	}

	public void testGetUIDLs() throws Exception
	{

	}

	public void testGetUIDLsByDate() throws Exception
	{

	}

	public void testForwardMail() throws Exception
	{
		ISearchDestination dest = store.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER);
		ExchewsObjectIndex oid = ExchEWSTranslator.createIndex(fwdMailId);
		assertNotNull(store);
		IMailDTO mail = store.getMail(acc, dest, oid);
		assertNotNull(mail);
		assertNotNull(mail.getBody());
		assertTrue(mail.getBody().length()>0);
		assertFalse(mail.isNew());
		assertTrue(mail instanceof ExchewsMailDTO);
		HeaderDTO header = mail.getHeader();
		assertNotNull(header);
		assertNotNull(header.getHeaderFrom());
		assertNotNull(header.getHeaderSendDate());
		assertTrue(mail.getAttachments().length>0);
		MailParseHelper h = new MailParseHelper(mail);
		IMailDTO fwd = getForwardMail(h);
		assertNotNull(fwd);
		MailAddress[] a = {new MailAddress("܂˂","test@amax.co.jp")};
		fwd.setTo(a);
Log.debug("foward mail");

		IObjectIndex idx = store.sendMail(acc,fwd);
		assertNotNull(idx);
	}

	public void teXstSendMail() throws Exception
	{
		assertNotNull(store);
//		ExchewsMailDTO mail = (ExchewsMailDTO)store.getMail(acc,store.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),new BasicObjectIndex("http://172.16.3.1/exchange/test@connectone.co.jp/%E5%8F%97%E4%BF%A1%E3%83%88%E3%83%AC%E3%82%A4/%E3%80%90c1v2_test%E3%80%91%E5%95%8F%E9%A1%8C%E3%81%AA%E3%81%97%2020100414.EML"));
		ExchewsMailDTO mail = new ExchewsMailDTO();

		assertNotNull(mail);
		MailAddress[] a = {new MailAddress("test","test@maxsol.co.jp")};
		mail.setBCC(a);
		mail.setSubject("EWS Send Test[Ȃ̂");
		mail.setBody("ڂŁ[");
Log.debug("send mail");

		IObjectIndex idx = store.sendMail(acc,mail);
		assertNotNull(idx);

	}

	public void teXstDelete() throws Exception
	{
		boolean catchException=false;
		assertNotNull(store);
		try {
			store.deleteMail(acc, null);
		}
		catch (HandleException e) {
			catchException=true;
		}
		catch (Exception e) {
			Log.debug("unexpected exception",e);
		}
		assertTrue(catchException);

		catchException=false;
		assertNotNull(mailid);
		ExchewsObjectIndex oid = ExchEWSTranslator.createIndex(mailid);
		try {
			store.deleteMail(acc, oid);
		}
		catch (HandleException e) {
			catchException=true;
		}
		catch (Exception e) {
			Log.debug("unexpected exception",e);
		}
		assertFalse(catchException);

	}

	public void testGetAllDatas() throws Exception
	{

	}

	public void testGetFolderIndexFromString() throws Exception
	{

	}

	public void testGetName() throws Exception
	{
		String name = store.getName();
		assertNotNull(name);
		assertEquals("Exchange EWS mail store",name);
	}

	public void testGetPresetDestination() throws Exception
	{
		ISearchDestination dest = store.getPresetDestination(acc, IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER);
		assertNotNull(dest);
		assertNull(dest.getDatabase());
		IFolderIndex folder = dest.getFolder();
		assertNotNull(folder);
		assertTrue(folder instanceof ExchewsFolderIndex);
	}

	public void testGetServiceInfo() throws Exception
	{
		IServiceInfo info = (ExchewsServiceInfo) store.getServiceInfo();
		assertNotNull(info);
		assertTrue(info instanceof ExchewsServiceInfo);
	}

	public void testGetStoreID() throws Exception
	{
		IStoreID id = store.getStoreID();
		assertNotNull(id);
		assertTrue(id instanceof SimpleStoreID);
		SimpleStoreID ids = (SimpleStoreID)id;
		assertTrue(ids.equals(new SimpleStoreID(ExchewsMailStoreImpl.class.getName())));
	}

	public void testRead() throws Exception
	{

	}

	public void testSearch() throws Exception
	{

	}

	public void testSearchByDate() throws Exception
	{

	}

	public void testWrite() throws Exception
	{

	}


	private void dumpDTO(IMailDTO dto)
	{
		if (dto instanceof ExchewsMailDTO) {
			ExchewsMailDTO dto2 = (ExchewsMailDTO) dto;
			Log.debug("=====ExchewsMailDTO=====================");
			Log.debug("oid:"+dto2.getOid());
			Log.debug("hasattachments:"+dto2.isHasAttachments());
//			Log.debug("bcc:"+dto2.getBcc());
//			Log.debug("cc:"+dto2.getCc());
			Log.debug("dateTimeSent:"+dto2.getDateTimeSent());
			Log.debug("dateTimeReceived:"+dto2.getDateTimeReceived());
			Log.debug("displaycc:"+dto2.getDisplayCc());
			Log.debug("displayto:"+dto2.getDisplayTo());
			Log.debug("from:"+dto2.getFrom());
			Log.debug("importance:"+dto2.getImportance());
			Log.debug("priority:"+dto2.getPriority());
			Log.debug("read:"+dto2.isRead());
			Log.debug("sender:"+dto2.getSender());
			Log.debug("subject:"+dto2.getSubject());
			Log.debug("body:"+dto2.getBody());
			Log.debug("submitted:"+dto2.isSubmitted());
			Log.debug("to:"+dto2.getTo());
			if (dto.getNumberOfAttachments()>0) {
				AttachmentDTO att = dto.getAttachment(0);
				Log.debug("dump file "+att.getFileName()+" to c:\\tmp");
				try {
					FileOutputStream fos = new FileOutputStream("c:\\tmp\\"+att.getFileName());
					fos.write(att.getFileBody());
				}
				catch (Exception e) {
					Log.debug("dump failed");
				}
			}
			Log.debug("=======================================");
		}
		else {
			dumpDTO2(dto);
		}

	}

	private void dumpHeader(HeaderDTO h)
	{
		Log.debug("+++++++++++++++++++++++++++++++++++++++");
		Log.debug("subject:"+h.getHeaderSubject());
		Log.debug("from:"+h.getHeaderFrom().getRawAddress());
		Log.debug("UID:"+h.getHeaderUIDL());
		Log.debug("to:"+array2String(h.getHeaderTo()));
		if (h.getHeaderCC()!=null) Log.debug("cc:"+array2String(h.getHeaderCC()));
		Log.debug("+++++++++++++++++++++++++++++++++++++++");
	}

	private void dumpDTO2(IMailDTO dto)
	{
		HeaderDTO h = dto.getHeader();
		Log.debug("=======================================");
		Log.debug(h.getHeaderSubject());
		Log.debug(h.getHeaderFrom().getRawAddress());
//		Log.debug(h.getHeaderReplyTo());
		Log.debug(h.getHeaderUIDL());
		Log.debug(array2String(h.getHeaderTo()));
		if (h.getHeaderCC()!=null) Log.debug(array2String(h.getHeaderCC()));
		Log.debug(dto.getBody());
		if (dto.getNumberOfAttachments()>0) {
			AttachmentDTO att = dto.getAttachment(0);
			Log.debug("dump file "+att.getFileName()+" to c:\\tmp");
			try {
				FileOutputStream fos = new FileOutputStream("c:\\tmp\\"+att.getFileName());
				fos.write(att.getFileBody());
			}
			catch (Exception e) {
				Log.debug("dump failed");
			}
		}
		Log.debug("=======================================");
	}

	private String array2String(MailAddress[] ar)
	{
		if (ar==null) return "";
		return "" + Arrays.asList(ar);
	}


	private static IMailDTO getForwardMail(MailParseHelper org)
	{
		Log.trace("WebMailParseHelper::getForwardMail called,calling getNewMail()");
		IMailDTO mail = new ExchewsMailDTO();
		mail.setSubject("Fw:" + org.getSubject());

		mail.setAttachments(org.getAttachments());

		return mail;
	}
}
