/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.test;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;

import jp.co.connectone.eai.exchews.store.*;
import jp.co.connectone.eai.exchews.user.*;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.log.Log;
import junit.framework.TestCase;
import jp.co.connectone.store.client.*;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.store.*;
import jp.co.connectone.user.*;

/**
 * @author amanot
 *
 */
public class TestExchewsAddressBookImpl extends TestCase {
	private ExchewsAddressBookStoreImpl AddressBookStore;
	private ExchewsAccountData acc;
	private ExchewsServiceInfo si;
	/* ( Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		AddressBookStore = new ExchewsAddressBookStoreImpl();
		IUserKey uid = new BasicUserKey(String.class.getName(),"test");
		si = (ExchewsServiceInfo)AddressBookStore.getServiceInfo();
		si.setServerAddress("172.16.3.1");
		si.setAdAddress("172.16.3.2");
		acc = new ExchewsAccountData(uid,si);
		acc.setUserID("test");
		acc.setPassword("Password");
		acc.setDomain("test.connectone.co.jp");
	}
	/* ( Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		AddressBookStore = null;
	}
	
	public void testSearchAddressBookG() throws Exception
	{
		SearchConditionCollection conds = new SearchConditionCollection();
Log.debug("global address book");
		AddressBookSearchCondition cond = new AddressBookSearchCondition(AddressBookSearchCondition.CONDITION.TYPE_DISPLAYNAME,"taka");
		conds.add(cond);
		ISearchDestination dest = AddressBookStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_SERVER_ADDRESSBOOK);
		SearchFormulaBaseImpl formula = new SearchFormulaBaseImpl(dest,null,conds);
		IAddressDTO[] rc = AddressBookStore.searchAddressBook(acc,formula);
		assertNotNull(rc);
		for (int i=0;i<rc.length;i++) {
			dumpDTO(rc[i]);
		}
	}
	
	public void testSearchAddressBookL() throws Exception
	{
Log.debug("local address book");
		SearchConditionCollection conds = new SearchConditionCollection();
		AddressBookSearchCondition cond = new AddressBookSearchCondition(AddressBookSearchCondition.CONDITION.TYPE_DISPLAYNAME,"");
		conds.add(cond);
		ISearchDestination dest = AddressBookStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_ADDRESSBOOK_FOLDER);
		SearchFormulaBaseImpl formula = new SearchFormulaBaseImpl(dest,null,conds);
		IAddressDTO[] rc = AddressBookStore.searchAddressBook(acc,formula);
		assertNotNull(rc);
		for (int i=0;i<rc.length;i++) {
			dumpDTO(rc[i]);
		}
	}

	public void testGetAddressBookItemG() throws Exception
	{
		ISearchDestination dest = AddressBookStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_SERVER_ADDRESSBOOK);
		IAddressDTO rc = AddressBookStore.getAddressBookItem(acc,dest,new BasicObjectIndex("saki"));
		assertNotNull(rc);
		dumpDTO(rc);
	}

	public void testGetAddressBookItemL() throws Exception
	{
		ISearchDestination dest = AddressBookStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_ADDRESSBOOK_FOLDER);
		IAddressDTO rc = AddressBookStore.getAddressBookItem(acc,dest,ExchEWSTranslator.createIndex("AAMkADFhNGI3N2Q0LWRkNWItNDBhNy04ODIyLWUyMjYxNGU1MzE2ZgBGAAAAAAByYJ+pxeduSYit4EQVkQLFBwDAyRCo9hqpT60LcrpLV3HzAAALPsNwAAC994qxD0rdTLqAc+xnPTyTAAALPzQCAAA="));
		assertNotNull(rc);
		dumpDTO(rc);
	}
	
	private void dumpDTO(IAddressDTO dto)
	{
		Log.debug("=======================================");
		try {
			Log.debug("oid:"+((ItemIdType)dto.getOid().getIndex()).getId());
		}
		catch(ClassCastException cce) {
			Log.debug("oid:"+dto.getOid().getIndex().toString());
		}
		Log.debug(dto.getDisplayName());
		Log.debug(dto.getFirstName());
		Log.debug(dto.getFamilyName());
		Log.debug(dto.getMobilePhone());
		Log.debug(dto.getEmail());
		Log.debug(dto.getCompanyAddress());
		Log.debug("=======================================");
	}
}
