/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.test;

import java.util.Arrays;
import java.util.List;

import jp.co.connectone.eai.exchews.ews.EWSSearchFormula;
import jp.co.connectone.eai.exchews.ews.IEwsSearchFormula;
import jp.co.connectone.log.Log;
import junit.framework.TestCase;

public class TestEWSSearchFormula extends TestCase
{
	public void testConstractor(){
		boolean catchException=false;
		try {
			Log.info("should be error.");
			@SuppressWarnings("unused")
			EWSSearchFormula f = new EWSSearchFormula(null, null, null);
		}
		catch (Exception e) {
			catchException = true;
		}
		assertTrue(catchException);
		catchException=false;
		try {
			Log.info("should not be error.");
			@SuppressWarnings("unused")
			EWSSearchFormula f = new EWSSearchFormula(null, IEwsSearchFormula.ALL_PROPERTIES, null);
		}
		catch (Exception e) {
			catchException = true;
		}
		try {
			Log.info("should not be error.");
			List<String> fields = Arrays.asList("ExchewsMailDTO.subject","ExchewsMailDTO.from","ExchewsMailDTO.to");
			@SuppressWarnings("unused")
			EWSSearchFormula f = new EWSSearchFormula(null, fields, null);
		}
		catch (Exception e) {
			catchException = true;
		}
		assertFalse(catchException);
		try {
			Log.info("should be error.");
			List<String> fields = Arrays.asList("BasicMailDTO.subject","BasicMailDTO.from","BasicMailDTO.to");
			@SuppressWarnings("unused")
			EWSSearchFormula f = new EWSSearchFormula(null, fields, null);
		}
		catch (Exception e) {
			catchException = true;
		}
		assertTrue(catchException);
		
	}
}
