/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;


public class NoSecuritySSLSocketFactory extends SSLSocketFactory
{
	private SSLSocketFactory delegate;
	
	public static SSLSocketFactory getDefault()
	{
		return new NoSecuritySSLSocketFactory();
	}

	public NoSecuritySSLSocketFactory()
	{
		super();
		try {
			SSLContext context = SSLContext.getInstance("TLS");
			context.init(null, new TrustManager[] { new NoSecuritySSLTrustManager() }, new java.security.SecureRandom());
			delegate = (SSLSocketFactory) context.getSocketFactory();
		}
		catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	@Override
	public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException
	{
		return delegate.createSocket(s, host, port, autoClose);
	}

	@Override
	public String[] getDefaultCipherSuites()
	{
		return delegate.getDefaultCipherSuites();
	}

	@Override
	public String[] getSupportedCipherSuites()
	{
		return delegate.getSupportedCipherSuites();
	}

	@Override
	public Socket createSocket(String host, int port) throws IOException, UnknownHostException
	{
		return delegate.createSocket(host, port);
	}

	@Override
	public Socket createSocket(InetAddress host, int port) throws IOException
	{
		return delegate.createSocket(host, port);
	}

	@Override
	public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException
	{
		return delegate.createSocket(host, port, localHost, localPort);
	}

	@Override
	public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException
	{
		return delegate.createSocket(address, port, localAddress, localPort);
	}

}
