import jp.co.connectone.eai.exch2k.store.Exch2kMemoStoreImpl;
import jp.co.connectone.eai.exch2k.store.Exch2kServiceInfo;
import jp.co.connectone.eai.exch2k.user.Exch2kAccountData;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.user.*;
import junit.framework.TestCase;
/**
 * @author amanot
 *
 */
public class TestExch2kMemoImpl extends TestCase {
	private Exch2kMemoStoreImpl memoStore;
	private PasswordBasedAccountDataImpl acc;
	/* ( Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		memoStore = new Exch2kMemoStoreImpl();
		IUserKey uid = new BasicUserKey(String.class.getName(),"test");
		Exch2kServiceInfo si = (Exch2kServiceInfo)memoStore.getServiceInfo();
		si.setServerAddress("172.16.3.1");
		acc = new Exch2kAccountData(uid,si);
		acc.setUserID("test");
		acc.setPassword("********");
	}
	/* ( Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		memoStore = null;
	}

	public void teXstCreateNewMemo() throws Exception
	{
		assertNotNull(memoStore);
		IMemoDTO memo = new BasicMemoDTO();
		memo.setSenderName("amanot@amax.co.jp");
		memo.setBody("ڂł[ł񂪂ȁB");
		memo.setSubject("薼");
		
		Object oid = memoStore.createNewMemo(acc,memo);
		Log.debug(oid.toString());
	}

	public void testGetMemos() throws Exception
	{
		assertNotNull(memoStore);
		IMemoDTO[] h = memoStore.getAllMemos(acc);
		assertNotNull(h);
		assertTrue(h.length>0);
		assertFalse(h[0].isNew());
		for (int i=0;i<h.length;i++) {
			dumpDTO(h[i]);
		}
	}
	
	private void dumpDTO(IMemoDTO dto)
	{
		Log.debug("============================");
		Log.debug(dto.getSubject());
		Log.debug(dto.getBody());
		Log.debug(dto.getSenderName());
	}
}
