/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exch2k.dav;

import org.apache.webdav.lib.util.XMLPrinter;
import java.util.*;

/**
 * @author amanot
 *
 */
public class ExXMLPrinter extends XMLPrinter {
	@SuppressWarnings("unchecked")
	public void writeElementWithNameSpaceList(LinkedHashMap namespaceList, String nameSpaceForInitial, String name)
	{
		String initialStr = "";
		String nsStr = "";
		Iterator nameSpaces = namespaceList.keySet().iterator();
		initialStr = "<D:" + name + " xmlns:D=\"DAV:\"";
		while (nameSpaces.hasNext()) {
			String namespace = (String)nameSpaces.next();
			String namespaceInfo = (String)namespaceList.get(namespace);
			if (namespaceInfo.equalsIgnoreCase("DAV:")) {
				continue;
			}
			nsStr = nsStr + " xmlns:" + namespace + "=\""+ namespaceInfo + "\"";
		}
		String str = initialStr + nsStr + ">";
        buffer.append(str);

	}
}
