/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exch2k.dav;

import java.util.*;

import jp.co.connectone.log.Log;

import org.apache.webdav.lib.methods.PropPatchMethod;
import org.apache.webdav.lib.util.XMLPrinter;

public class ExPropPatchMethod extends PropPatchMethod {
    @SuppressWarnings("unchecked")
	protected TreeMap toSet = new TreeMap();

	/**
	 * 
	 */
	public ExPropPatchMethod() {
		super();
	}
	/**
	 * @param path
	 */
	public ExPropPatchMethod(String path) {
		super(path);
	}
    @SuppressWarnings("unchecked")
	public void addPropertyToSet(String name, String value) {
        checkNotUsed();
        ExPropPatchProperty propertyToSet = new ExPropPatchProperty();
        if (name != null) {
            propertyToSet.setName(name);
            if (value != null) {
                propertyToSet.setValue(value);
            }
            else {
                propertyToSet.setValue(value);
            }
            toSet.put(propertyToSet, propertyToSet);
        }
    }

    @SuppressWarnings("unchecked")
	public void addPropertyToRemove(String name) {
        checkNotUsed();
        ExPropPatchProperty propertyToRemove = new ExPropPatchProperty();
        if (name != null) {
        	propertyToRemove.setName(name);
            toRemove.put(name, propertyToRemove);
        }
    }

    @SuppressWarnings("unchecked")
	protected LinkedHashMap getNameSpaces()
    {
        LinkedHashMap NSList = new LinkedHashMap();
        if (toSet.size() > 0) {
        	Set valueset = toSet.entrySet();
        	Iterator it = valueset.iterator();
        	String prevNameSpace = null;
            while (it.hasNext()) {
            	Map.Entry o = (Map.Entry)it.next();
                ExPropPatchProperty current = (ExPropPatchProperty) o.getValue();
            	if (current.getNamespaceInfo()!=null) {
                	if (current.getNamespaceInfo().equalsIgnoreCase(prevNameSpace)) {
                	}
                	else {
                		prevNameSpace = current.getNamespaceInfo();
                		NSList.put(current.getNamespace(),current.getNamespaceInfo());;
                	}
            	}
            }
        }
        return NSList;
    }

    @SuppressWarnings("unchecked")
	protected String generateRequestBody() {
        ExXMLPrinter printer = new ExXMLPrinter();

Log.debug("ExPropPatchMethod");
        printer.writeXMLHeader();
        printer.writeElementWithNameSpaceList(getNameSpaces(), "DAV:", "propertyupdate");

        if (toSet.size() > 0) {

        	
            printer.writeElement("D", null, "set", XMLPrinter.OPENING);
        	Set valueset = toSet.entrySet();
        	Iterator it = valueset.iterator();

            printer.writeElement("D", null, "prop", XMLPrinter.OPENING);

            while (it.hasNext()) {
            	Map.Entry o = (Map.Entry)it.next();
                ExPropPatchProperty current = (ExPropPatchProperty) o.getValue();
                if ("DAV:".equals(current.getNamespaceInfo())) {
                    printer.writeProperty("D", null, current.getName(), current.getValue());
                }
                else {
                	if (current.getNamespaceInfo()==null) {
                        printer.writeProperty(null, null, current.getName(), current.getValue());
                	}
                	else {
                        printer.writeProperty(current.getNamespace(), null, current.getName(), current.getValue());
                	}
                }
                
            }
            printer.writeElement("D", null, "prop", XMLPrinter.CLOSING);
            printer.writeElement("D", null, "set", XMLPrinter.CLOSING);
            
            
        }

        if (toRemove.size() > 0) {

            printer.writeElement("D", null, "remove", XMLPrinter.OPENING);

            Enumeration toRemoveList = toRemove.elements();
            printer.writeElement("D", null, "prop", XMLPrinter.OPENING);
            while (toRemoveList.hasMoreElements()) {
//            	ExPropPatchProperty current = (ExPropPatchProperty) toRemoveList.nextElement();
//                printer.writeElement(current.getNamespace(), current.getNamespaceInfo(),
//                                     current.getName(), XMLPrinter.NO_CONTENT);
            }
            printer.writeElement("D", null, "prop", XMLPrinter.CLOSING);

            printer.writeElement("D", null, "remove", XMLPrinter.CLOSING);

        }

        printer.writeElement("D", "propertyupdate", XMLPrinter.CLOSING);
        String prtStr = printer.toString();
Log.debug("request body = "+prtStr);
        
        return prtStr;
    }
}
