/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exch2k.dav;

import java.text.SimpleDateFormat;
import java.util.TimeZone;

/**
 * @author amanot
 *
 */
@SuppressWarnings("serial")
public class DavDateFormat extends SimpleDateFormat
{
	public static final int FORMAT_DAV_TZ_MSEC=1;
	public static final int FORMAT_DAV_T_SEC=2;
	public DavDateFormat()
	{
		setFormatType(FORMAT_DAV_TZ_MSEC);
	}
	
	public DavDateFormat(int formatType)
	{
		setFormatType(formatType);
	}
	
	public void setFormatType(int formatType)
	{
	    setLenient( false );
	    switch(formatType) {
	    case FORMAT_DAV_TZ_MSEC:
		    setTimeZone(TimeZone.getTimeZone("GMT"));
		    applyPattern( "yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'" );
		    break;
	    case FORMAT_DAV_T_SEC:
		    setTimeZone(TimeZone.getTimeZone("GMT"));
		    applyPattern( "yyyy-MM-dd'T'HH:mm:ss'Z'" );
		    break;
	    default:
	    	throw new IllegalArgumentException("format type not supported");
	    }
	}
}
