/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.notes.store.pim;

import java.util.Date;

import jp.co.connectone.store.pim.IMailParseHelperComparator;
import jp.co.connectone.store.pim.MailParseHelper;

public class NotesMailParseHelperComparator extends IMailParseHelperComparator
{

	public static final int SUBJECT = 0;
	public static final int SENTDATE = 1;
	public static final int RECEIVEDDATE = 2;
	private int sortKey = 0;
	private boolean reverce = false;

	public NotesMailParseHelperComparator(int sortKey, boolean isReverce)
	{
		super(sortKey, isReverce);
		this.sortKey = sortKey;
		this.reverce = isReverce;
	}

	@Override
	public int compare(MailParseHelper o1, MailParseHelper o2)
	{
		if (o1 == null) {
			return 0;
		}
		if (o2 == null) {
			return 0;
		}
		MailParseHelper src = o1;
		MailParseHelper dst = o2;
		switch (sortKey) {
		case SUBJECT:
			String s1 = src.getSubject();
			String s2 = dst.getSubject();
			if (s1 == null || s2 == null) {
				return 0;
			}
			if (reverce) {
				return s2.compareTo(s1);
			}
			else {
				return s1.compareTo(s2);
			}
		case SENTDATE:
			Date d1 = src.getSentDate();
			Date d2 = dst.getSentDate();
			if (d1 == null || d2 == null) {
				return 0;
			}
			if (reverce) {
				return d2.compareTo(d1);
			}
			else {
				return d1.compareTo(d2);
			}
		case RECEIVEDDATE:
			d1 = src.getReceivedDate();
			d2 = dst.getReceivedDate();
			if (d1 == null || d2 == null) {
				return 0;
			}
			if (reverce) {
				return d2.compareTo(d1);
			}
			else {
				return d1.compareTo(d2);
			}
		}

		return 0;
	}
}
