/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.notes.store;

import java.util.HashMap;

import jp.co.connectone.eai.notes.user.NotesAccountData;
import jp.co.connectone.service.*;
import jp.co.connectone.store.*;

/**
 * @author amanot
 *
 */
public class NotesServiceInfo extends ServiceInfo
{
	private static final long serialVersionUID = 1L;
	protected 	String 		serverAddress2;
	private String database;
	public HashMap<String,Object> getFieldSet()
	{
		HashMap<String,Object> map = new HashMap<String,Object>();
		map.put("storeID",storeID);
		map.put("name",name);
		map.put("serverAddress",serverAddress);
		map.put("serverAddress2",serverAddress2);
		map.put("database",database);
		return map;
	}
	
	public void setFieldSet(HashMap<String,Object> h)
	{
		if (h==null) {
			storeID=null;
			name=null;
			serverAddress=null;
			serverAddress2=null;
			database=null;
		}
		else {
			storeID=(IStoreID)h.get("storeID");
			name=(String)h.get("name");
			serverAddress=(String)h.get("serverAddress");
			serverAddress2=(String)h.get("serverAddress2");
			database=(String)h.get("database");
		}
	}
	public boolean equals(Object obj)
	{
		if (!(obj instanceof NotesServiceInfo)) return false;
		NotesServiceInfo o = (NotesServiceInfo)obj;
		String src1 = storeID.getStoreID()+"."+serverAddress+"/"+serverAddress2+"."+database;
		String src2 = o.storeID.getStoreID()+"."+o.serverAddress+"/"+o.serverAddress2+"."+o.database;
		return src1.equals(src2);
	}

	public String getAccountClassName()
	{
		return NotesAccountData.class.getName();
	}

	/**
	 * @param storeID
	 * @param type
	 * @param name
	 */
	public NotesServiceInfo(IStoreID storeID, String name)
	{
		super(storeID, name);
	}

	public String getDatabase()
	{
		return database;
	}

	public void setDatabase(String database)
	{
		this.database = database;
	}

	public String getServerAddress2()
	{
		return serverAddress2;
	}

	public void setServerAddress2(String serverAddress2)
	{
		this.serverAddress2 = serverAddress2;
	}

}
