/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.notes.store;

import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.pim.*;

public class NotesScheduleDTO extends BasicScheduleDTO {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private boolean isnew=true;

	public void setScheduleType(int type) 
	{
		this.type = type;
	}

	public void setRepeatFlag(boolean repeatFlag)
	{
		this.repeatFlag =repeatFlag;
	}

	public void setRepeatType(String repeatType)
	{
		this.repeatType = repeatType;
	}

	public void setCategory(String category)
	{
		this.category = category;
	}

	public int getScheduleType()
	{
		return this.type;
	}

	public boolean getRepeatFlag()
	{
		return this.repeatFlag;
	}

	public String getRepeatType() 
	{
		return this.repeatType;
	}

	public String getCategory()
	{
		return this.category;
	}

	private int type;
	private boolean repeatFlag=false;
	private String repeatType=null;
	private String category=null;
	private String[] description=null;

	/* ( Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return super.toString() + ":" + boid.getIndex() + ":" + subject;
	}

	public String[] getDescription() {
		return description;
	}

	public void setDescription(String[] description) {
		this.description = description;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.pim.BasicScheduleDTO#setOid(jp.co.connectone.store.IObjectIndex)
	 */
	public void setOid(IObjectIndex oid)
	{
		super.setOid(oid);
		isnew = false;
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.pim.BasicScheduleDTO#setBody(java.lang.String)
	 */
	public void setBody(String body)
	{
		super.setBody(body);
		String[] l_byteFilestream = new String[1];
		l_byteFilestream[0] = body;
		setDescription( l_byteFilestream);		
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.store.BasicRecordObject#isNew()
	 */
	public boolean isNew()
	{
		return isnew;
	}
}