/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.user;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map.Entry;

public interface IUser
{

	public abstract void addAccountData(IAccountData newAccData);

	public abstract IAccountData getAccountData(String serviceCode);

	public abstract Iterator<Entry<String, IAccountData>> getAllAcountDatas();


	public abstract UserInfo getPrimaryUserInfo();

	public abstract void setPrimaryUserInfo(UserInfo primaryAddressInfo);
	
	/**
	 * @return authParams ߂܂B
	 */
	public abstract Hashtable<String,Object> getAuthParams();

	/**
	 * @param authParams
	 *            ݒ肷 authParamsB
	 */
	public abstract void setAuthParams(Hashtable<String,Object> authParams);

	/**
	 * @return key ߂܂B
	 */
	public abstract IUserKey getKey();

	/**
	 * @param key
	 *            ݒ肷 keyB
	 */
	public abstract void setKey(IUserKey key);

}