/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;

import java.util.Date;

import jp.co.connectone.store.*;

public interface IMailDTO extends IRecordObject
{
	public String getSubject();
	public void setSubject(String subject);
	public int getSize();
	public void setSize(int size);
	public MailAddress[] getTo();
	public MailAddress[] getCC();
	public MailAddress[] getBCC();
	public MailAddress getFrom();
	public MailAddress getReplyTo();
	public int getPriority();
	public Date getSentDate();
	public Date getReceivedDate();
	public void setTo(MailAddress[] to);
	public void setCC(MailAddress[] cc);
	public void setBCC(MailAddress[] bcc);
	public void setFrom(MailAddress from);
	public void setReplyTo(MailAddress replyTo);
	public void setPriority(int priority);
	public void setSentDate(Date date);
	/**
	 * This method gets message body.
	 * @return body body of the message
	 */
	public String getBody();
	
	/**
	 * This method gets number of attachments of the message.
	 * @return numOfAttachments number of attachments
	 */
	
	public int getNumberOfAttachments();
	
	/**
	 * This method gets attachment by index value.
	 * @param number index value
	 * @return attachments attachment by index
	 */
	public AttachmentDTO getAttachment(int number);
	
	/**
	 * This method gets header of the message.
	 * @return header header object 
	 */
	public HeaderDTO getHeader();
	
	/**
	 * 
	 * @return
	 */
	public String getMailBinary();
	
	/**
	 * This method sets body to BasicMailDTO.
	 * @param body message body
	 */
	public void setBody(String body);
	
	/**
	 * This method sets HeaderDTO to BasicMailDTO.
	 * @param header HeaderDTO object
	 */
	public void setHeaderDTO(HeaderDTO header);
	
	/**
	 * This method sets attachments to BasicMailDTO
	 * @param attachments byte stream of attachments
	 */
	public void setAttachments(AttachmentDTO[] attachments);
	
	/**
	 * @return attachments ߂܂B
	 */
	public AttachmentDTO[] getAttachments() ;
	/**
	 * @deplaced Object oid is replaced with IObjectIndex interface
	 * @see jp.co.connectone.store.client.IMailDTO#getObjectIndex()
	 */
	public abstract IObjectIndex getOid();

	/**
	 * @deplaced Object oid is replaced with IObjectIndex interface
	 * @see jp.co.connectone.store.client.IMailDTO#setObjectIndex(IObjectIndex oid)
	 */
	public abstract void setOid(IObjectIndex oid);

}
