/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store;

import java.util.*;

import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.user.IAccountData;

/**
 * @author amanot
 */
public interface IStore
{
	public IStoreID getStoreID() throws Exception;
	public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception;
	public String getName() throws Exception;
	public ISearchDestination getPresetDestination(IAccountData acc,int type) throws IncorrectData, HandleException;
	public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception;
	public IRecordObject getFolderIndexFromString(String path) throws IncorrectData;
	public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception;
	public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws Exception;
	public IRecordObject[] search(IAccountData acc, ISearchFormula col) throws Exception;
	public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception;
	public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception;
	public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception;
}
