/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.security;

import java.lang.reflect.Method;
import java.util.Hashtable;

import jp.co.connectone.log.Log;

public class OptionalSecurityWrapper2
{
	public static boolean securityCheck(Hashtable<String,Object> params1,Hashtable<String,Object> params2)
	{
		boolean rc = false;
		Class<?> termIdSequrityClass = null;
		try {
			Log.debug("trying to call BizBrowser parameter check.");
			termIdSequrityClass = Class.forName("jp.co.connectone.webproxy.user.BizBrowserIdSecurityHandler");
		}
		catch (Exception e) {
			Log.debug("BizBrowserIdSecurityHandler not found. try other check");
			try {
				Log.debug("trying to call TermIdSecurityHandler parameter check.");
				termIdSequrityClass = Class.forName("jp.co.connectone.webproxy.user.TermIdSecurityHandler");
			}
			catch (Exception te) {
				Log.debug("TermIdSecurityHandler not found. path thruogh check");
				return true;
			}
		}
		try {
			Class<?>[] securityCheckParameterTypes = {Hashtable.class,Hashtable.class};
			Method securityCheck = termIdSequrityClass.getMethod("securityCheck", securityCheckParameterTypes);
			Object[] args = {params1,params2};
			Boolean b = (Boolean)securityCheck.invoke(null, args);
			rc = b.booleanValue();
		}
		catch (Exception e) {
			Log.debug("error on securityCheck.",e);

		}
		return rc;
	}
}
