/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.helpers;

import java.util.*;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.webapps.tools.DateControler;

/**
 * @author amanot
 *
 */
public class WebScheduleParseHelper extends ScheduleParseHelper {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public WebScheduleParseHelper()
	{
		initDTO();
	}
	
	private void initDTO()
	{
		schedule = new BasicScheduleDTO();
		schedule.setBody("");
//		schedule.setCategory("\");
		schedule.setStartDate(new Date());
		schedule.setEndDate(new Date());
		schedule.setLocation("");
//		schedule.setRepeatFlag(false);
//		schedule.setScheduleType(0);

		schedule.setSubject("");
		String[] l_byteFilestream = new String[1];
		String bodyStr = new String("");
		l_byteFilestream[0] = bodyStr;
	}
	
	public void escapeTags() {
		schedule.setBody(extention.escapeTags(schedule.getBody()));
		schedule.setSubject(extention.escapeTags(schedule.getSubject()));
		schedule.setLocation(extention.escapeTags(schedule.getLocation()));
	}
	
	public int getPrevPage()
	{
		return extention.getPrevPage();
	}
	
	public int getNextPage()
	{
		return extention.getNextPage();
	}

	public String getBodyHtml() {
		String rc = super.getBody();
		if (rc == null) return rc;
    	rc = extention.pagingString(rc);
		rc = extention.escapeTags(rc);
    	rc = extention.formatBody(rc);
		return rc;
	}

	public String getSubject() {
		String rc =  super.getSubject();
		if (rc==null) return "";
		if (rc.length()==0) return "";
		return rc;
	}
	
	
/* added module */
	protected WebParserAggregationBase extention=new WebParserAggregationBase();

	public static Comparator<WebScheduleParseHelper> getComparator()
	{
		return new WebScheduleParseHelperComparator();
	}
	/**
	 * @return bodyLength ߂܂B
	 */
	public int getBodyLength() {
		return extention.getBodyLength();
	}
	/**
	 * @param bodyLength bodyLength ݒB
	 */
	public void setBodyLength(int bodyLength) {
		extention.setBodyLength(bodyLength);
	}
	/**
	 * @return currentPage ߂܂B
	 */
	public int getCurrentPage() {
		return extention.getCurrentPage();
	}
	/**
	 * @param currentPage currentPage ݒB
	 */
	public void setCurrentPage(int currentPage) {
		extention.setCurrentPage(currentPage);
	}
	
	public WebScheduleParseHelper(ScheduleParseHelper org)
	{
		super(org.getScheduleDTO());
		super.setTid(""+extention.getNextID());
		
	}
	
	public int getLastPage() {
		return extention.getLastPage(super.getBody());
	}
	
	public String getStartDateStr()
	{
		return DateControler.getDateStr(getStartDate());
	}
	
	public String getEndDateStr()
	{
		return DateControler.getDateStr(getEndDate());
	}
	
	public String getStartHourStr()
	{
		return DateControler.getHourStr(getStartDate());
	}
	
	public String getEndHourStr()
	{
		return DateControler.getHourStr(getEndDate());
	}

}

class WebScheduleParseHelperComparator implements Comparator<WebScheduleParseHelper> {
	  public int compare(WebScheduleParseHelper obj1, WebScheduleParseHelper obj2) {
	  	
	    return obj1.getStartDate().compareTo(obj2.getStartDate());
	  }
}