/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.filters;

import java.io.IOException;

import javax.servlet.*;
import javax.servlet.http.*;

import jp.co.connectone.exception.HandleException;
import jp.co.connectone.webapps.commandenv.*;
import jp.co.connectone.webapps.security.OptionalSecurityWrapper;

/**
 * @author amanot
 *
 */
public class SetParameterBeansFilter extends BaseFilter implements Filter
{

	/* ( Javadoc)
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
	 */
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException
	{
		CommandEnvSet env = null;
		HttpSession session = ((HttpServletRequest)request).getSession(true);
		String key = (String)request.getParameter("key");
		if (key==null) {
			key = (String)request.getAttribute("key");
		}
		else if (key.length()==0) {
			key = (String)request.getAttribute("key");
		}
		CommandQueue q = new CommandQueue(session);
		try {
			env = q.getEnv(key);
		} catch (HandleException he) {}
		OptionalSecurityWrapper.setArgsFromRequest(env, (HttpServletRequest)request);
		
		// Pass control on to the next filter
        chain.doFilter(request, response);
	}
}
