package jp.co.connectone.webproxy.ui.action;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import javax.servlet.ServletContext;
import javax.servlet.http.*;

import jp.co.connectone.webapps.commandenv.CommandEnvSet;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.*;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.webapps.helpers.*;
import jp.co.connectone.webapps.struts.*;
import jp.co.connectone.webapps.tools.DateControler;
import jp.co.connectone.webproxy.ui.logic.*;
import jp.co.connectone.eai.notes.store.*;
import jp.co.connectone.eai.notes.store.pim.NotesMailParseHelperComparator;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.NoSuchRights;

import org.apache.struts.action.*;

/**
 * @author amanot
 *
 */
public class NotesMenuAction extends NotesAction
{

	/* ( Javadoc)
	 * @see jp.co.connectone.webproxy.ui.action.BaseAction#setArgs()
	 */
	protected void setArgs(CommandEnvSet env,DynaActionForm form)
	{
		String cmd = form.getString("cmd");
		String fc = form.getString("fc");
		String d = form.getString("d");
		Integer fidx = (Integer)form.get("fidx");
		Integer midx = (Integer)form.get("midx");
		Integer aidx = (Integer)form.get("aidx");
		Integer cp = (Integer)form.get("cp");
		Integer select = (Integer)form.get("select");
		String name = form.getString("name");
		String submit = form.getString("submit");
		Log.debug("submit="+submit);
		if (cmd!=null)if (cmd.length()>0)env.put("cmd",cmd);
		if (fc!=null)if (fc.length()>0)env.put("fc",fc);
		if (d!=null)if (d.length()>0)env.put("date",d);
		if (fidx!=null)env.put("fidx",fidx);
		if (midx!=null)env.put("midx",midx);
		if (aidx!=null)env.put("aidx",aidx);
		if (cp!=null)env.put("cp",cp);
		if (select!=null)env.put("select", select);
		if (name!=null)if (name.length()>0)env.put("name",name);
		if (submit!=null)if (submit.length()>0)env.put("submit",submit);
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.webproxy.ui.action.BaseAction#actionLogic(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward actionLogic(CommandEnvSet env,ActionMapping mapping, DynaActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception
	{
		String cmd = env.getString("cmd");
		String fc = env.getString("fc");
		Log.debug("cmd="+cmd+",fc="+fc);
		String dateStr = env.getString("date");
		Date date = null;
		if (dateStr==null) {
			date = new Date();
		}
		else if (dateStr.length()==0) {
			date = new Date();
		}
		else {
			DateControler dc = new DateControler(dateStr);
			date = dc.getDate();
			if (date==null) date = new Date();//in case error date String
		}
		request.setAttribute("date",date);


		try {
			if (cmd.equalsIgnoreCase(CMD_INBOX_MAIL)) {
				return processInboxMail(env,mapping, request, fc, date);
			}
			if (cmd.equalsIgnoreCase(CMD_FOLDER_MAIL)) {
				return processFolderMail(env,mapping, request, fc, date);
			}
			if (cmd.equalsIgnoreCase(CMD_SENT_MAIL)) {
				return processSentMail(env,mapping, request, fc, date);
			}
			if (cmd.equalsIgnoreCase(CMD_MAIL_SEARCH)) {
				return mapping.findForward("MailSearch");
			}
			if (cmd.equalsIgnoreCase(CMD_NEW_MAIL)) {
				return prepareNewMail(env,request,mapping,fc);
			}
			if (cmd.equalsIgnoreCase(CMD_PROCESS_MAIL)) {
				return processMail(env,form,request,mapping,fc,"NewMailSent");
			}
			if (cmd.equalsIgnoreCase(CMD_PROCESS_MAIL2)) {
				return processMail(env,form,request,mapping,fc,"ReplyMailSent");
			}
			if (cmd.equalsIgnoreCase(CMD_SCHEDULE)) {
				return processSchedule(env,mapping,request,fc, date);
			}
			if (cmd.equalsIgnoreCase(CMD_PROCESS_SCHEDULE)) {
				return processCreateSchedule(env,form,request,mapping,fc);
			}
			if (cmd.equalsIgnoreCase(CMD_ADDR_MENU)) {
				return processAddressBook(env,mapping, request, fc, date);
			}
		}
		catch (NoSuchRights sd) {
			if (sd.getMessage().indexOf("4486")>0) {
				return mapping.findForward("authError");
			}
			throw sd;
		}

		return mapping.findForward("error");
	}

	private ActionForward processAddressBook(CommandEnvSet env,ActionMapping mapping, HttpServletRequest request,String fc,Date date) throws Exception
	{
		if (fc.equalsIgnoreCase("init")) {
			return mapping.findForward("AddrSearch");
		}
		if (fc.equalsIgnoreCase(FC_LIST)) {
			env.put("cacheIdx",null);
			String name = env.getString("name");
			int select = ((Integer)env.get("select")).intValue();
			setList(env,request,searchServerAddressbook(env,name,select));
			StrutsArrayList list = (StrutsArrayList)request.getAttribute("list");
			int size = list.size();
			if (size > 20) {
				request.setAttribute("message", "܂Bi荞łB");
			}
			return mapping.findForward("AddrList");
		}
		if (fc.equalsIgnoreCase(FC_VIEW)) {
			Integer idx = (Integer)env.get("midx");
			IndexList idxList = (IndexList)env.get("nList");
			IObjectIndex mid = (IObjectIndex)idxList.get(idx.intValue());
			int mode = 0;
			mode = Controler.COMMON_ADDRESSBOOK;
			WebAddressParseHelper dto = ctrl.getAddressBookItem(env.getString("u"),env.getString("p"),mid,mode);
			addrAttrsSet(env,request,dto);
			return mapping.findForward("AddrDetail");
		}

		return mapping.findForward("error");
	}

	private boolean dateValidate(Date date,String d)
	{
		if (date==null) return false;// unexpected error
		if (d==null) return true;// no date arg requested.. default is today
		SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");

		String tmpd = f.format(date);
		if (d.equals(tmpd)) return true;// date made from d equals d... validated.
		return false;// in case d is not valid date format
	}

	/**
	 * @param mapping
	 * @return
	 */
	private ActionForward processSchedule(CommandEnvSet env,ActionMapping mapping, HttpServletRequest request,String fc,Date date) throws Exception
	{
		if (fc.equalsIgnoreCase(FC_NEW)) {
			WebScheduleParseHelper sche = new WebScheduleParseHelper(new ScheduleParseHelper(new NotesScheduleDTO()));
			sche.setStartDate(date);
			sche.setEndDate(date);
			env.put("nEditSchedule",sche);
			env.put("nScheStyle","NewSche");
			request.setAttribute("editSchedule",sche);
			return mapping.findForward("NewSche");
		}
		if (fc.equalsIgnoreCase(FC_EDIT)) {
			WebScheduleParseHelper sche = (WebScheduleParseHelper)env.get("nschedule");
			env.put("nEditSchedule",sche);
			request.setAttribute("editSchedule",sche);
			env.put("nScheStyle","ScheEdit");
			return mapping.findForward("ScheEdit");
		}
		if (fc.equalsIgnoreCase(FC_LIST)) {
			if (!(dateValidate(date,env.getString("date")))) {
				ActionMessages errors = new ActionMessages();
				ActionMessage mess =  new ActionMessage("errors.invalid","t");
				errors.add("error.schedate.format",mess);
				saveErrors(request, errors);
				date = new Date();// set today..as default.
				request.setAttribute("date",date);
			}

			Integer cp = (Integer)env.get("cp");
			setCmdCache(request.getSession(),CMD_SCHEDULE,null,cp);

			setList(env,request,getAllSchedules(env,date));
			return mapping.findForward("ScheList");
		}
		if (fc.equalsIgnoreCase(FC_VIEW)) {
			WebScheduleParseHelper sche = (WebScheduleParseHelper)env.get("nschedule");
			sche = getSchedule(env);
			scheduleAttrsSet(env,request, sche);
			return mapping.findForward("ScheDetail");
		}
		if (fc.equalsIgnoreCase(FC_DELCHECK)) {
			env.put("cacheIdx",null);
			return mapping.findForward("ScheDelCheck");
		}
		if (fc.equalsIgnoreCase(FC_DEL)) {
			if (checkDeleteIgnore(env)) {
				WebScheduleParseHelper sche = (WebScheduleParseHelper)env.get("nschedule");
				scheduleAttrsSet(env,request, sche);
				return mapping.findForward("ScheDetail");
			}
			env.put("cacheIdx",null);
			env.put("cp",null);
			env.put("date",null);
			deleteSchedule(env);
			return mapping.findForward("nMenu");
		}
		return mapping.findForward("error");
	}

	private ActionForward processCreateSchedule(CommandEnvSet env,DynaActionForm form, HttpServletRequest request,ActionMapping mapping, String fc) throws Exception
	{
		WebScheduleParseHelper newSche = (WebScheduleParseHelper)env.get("nEditSchedule");
		boolean rc = false;
		if (fc.equalsIgnoreCase("restore")) {
			request.setAttribute("editSchedule",newSche);
			String mode = env.getString("nScheStyle");
			return mapping.findForward(mode);
		}
		if (fc.equalsIgnoreCase("new")||fc.equalsIgnoreCase("edit")) {
			rc = processScheduleInput(form,newSche,request);
			String submit = form.getString("submit");
			Log.debug("submit="+submit);
			if (submit.indexOf("ۑ")>=0) {
				if (rc==false) {
					request.setAttribute("editSchedule",newSche);
					return mapping.findForward("ScheEdit");
				}
				NotesScheduleDTO scheduleDTO = (NotesScheduleDTO) newSche.getScheduleDTO();
				scheduleDTO.setScheduleType(SCHEDULE_PLAN);
				newSche.setScheduleDTO(scheduleDTO);
				return saveSchedule(env,form,mapping,newSche);
			}


			return mapping.findForward("error");
		}
		return mapping.findForward("error");
	}

	private ActionForward saveSchedule(CommandEnvSet env,DynaActionForm form,ActionMapping mapping,WebScheduleParseHelper newSche) throws Exception
	{
		String fromString=null;
		if (fromString==null) {
			fromString="";
		}

		try {
				ctrl.saveSchedule(env.getString("u"),env.getString("p"),newSche.getScheduleDTO());
		}
		catch(Exception e) {
			Log.error("", e);
			return mapping.findForward("authError");
		}
		return mapping.findForward("ScheSaved");
	}

	/**
	 * @param mapping
	 * @return
	 */
	private ActionForward prepareNewMail(CommandEnvSet env,HttpServletRequest request,ActionMapping mapping,String fc)
	{
		env.put("cacheIdx",null);
		if (fc.equalsIgnoreCase("New") ) {
			WebMailParseHelper newMail = WebMailParseHelper.getNewMail();
			env.put("nSendMail",newMail);
			env.put("nMailStyle","NewMail");
			request.setAttribute("sendMail",newMail);
			return mapping.findForward("NewMail");
		}
		WebMailParseHelper mail = (WebMailParseHelper)env.get("nmail");
		if (fc.equalsIgnoreCase("fw")) {
			WebMailParseHelper newMail = WebMailParseHelper.getForwardMail(mail);
			env.put("nSendMail",newMail);
			env.put("nMailStyle","FwMail");
			request.setAttribute("sendMail",newMail);
			return mapping.findForward("FwMail");
		}
		if (fc.equalsIgnoreCase("re")) {
			WebMailParseHelper newMail = WebMailParseHelper.getReplyMail(mail);
			env.put("nSendMail",newMail);
			env.put("nMailStyle","ReplyMail");
			request.setAttribute("sendMail",newMail);
			return mapping.findForward("ReplyMail");
		}
		if (fc.equalsIgnoreCase("reall")) {
			WebMailParseHelper newMail = WebMailParseHelper.getReplyAllMail(mail);
			env.put("nSendMail",newMail);
			env.put("nMailStyle","ReplyMail");
			request.setAttribute("sendMail",newMail);
			return mapping.findForward("ReplyMail");
		}
		if (fc.equalsIgnoreCase("ret")) {
			WebMailParseHelper newMail = (WebMailParseHelper)env.get("nSendMail");
			request.setAttribute("sendMail",newMail);
			return mapping.findForward((String)env.get("nMailStyle"));
		}
		return mapping.findForward("error");
	}

	/**
	 * @param mapping
	 * @return
	 */
	private ActionForward processMail(CommandEnvSet env,DynaActionForm form, HttpServletRequest request,ActionMapping mapping, String fc, String forward) throws Exception
	{
		WebMailParseHelper newMail = (WebMailParseHelper)env.get("nSendMail");
		boolean rc = false;
		if (fc.equalsIgnoreCase("restore")) {
			request.setAttribute("sendMail",newMail);
			String mode = env.getString("nMailStyle");
			return mapping.findForward(mode);
		}
		if (fc.equalsIgnoreCase("TOAddrAdd")) {
			String addressType = "g";
			IAddressDTO addr = getAddressBookItem(env,addressType);
			Collection<MailAddress> c = newMail.getTOCollection();
			MailAddress to = new MailAddress(addr.getEmail());
			c.add(to);
			MailAddress[] a = new MailAddress[1];
			a = (MailAddress[])c.toArray(a);
			newMail.setTO(a);
			request.setAttribute("sendMail",newMail);
			String mode = env.getString("nMailStyle");
			return mapping.findForward(mode);
		}
		if (fc.equalsIgnoreCase("CCAddrAdd")) {
			String addressType = "g";
			IAddressDTO addr = getAddressBookItem(env,addressType);
			Collection<MailAddress> c = newMail.getCCCollection();
			MailAddress cc = new MailAddress(addr.getEmail());
			c.add(cc);
			MailAddress[] a = new MailAddress[1];
			a = (MailAddress[])c.toArray(a);
			newMail.setCC(a);
			request.setAttribute("sendMail",newMail);
			String mode = env.getString("nMailStyle");
			return mapping.findForward(mode);
		}
		if (fc.equalsIgnoreCase("BCCAddrAdd")) {
			String addressType = "g";
			IAddressDTO addr = getAddressBookItem(env,addressType);
			Collection<MailAddress> c = newMail.getBCCCollection();
			MailAddress bcc = new MailAddress(addr.getEmail());
			c.add(bcc);
			MailAddress[] a = new MailAddress[1];
			a = (MailAddress[])c.toArray(a);
			newMail.setBCC(a);
			request.setAttribute("sendMail",newMail);
			String mode = env.getString("nMailStyle");
			return mapping.findForward(mode);
		}
		if (fc.equalsIgnoreCase("searchTO")) {
			String returnPath = "TOAddrList";
			return searchMailAddress(env,request, mapping, returnPath);
		}
		if (fc.equalsIgnoreCase("searchCC")) {
			String returnPath = "CCAddrList";
			return searchMailAddress(env,request, mapping, returnPath);
		}
		if (fc.equalsIgnoreCase("searchBCC")) {
			String returnPath = "BCCAddrList";
			return searchMailAddress(env,request, mapping, returnPath);
		}
		if (fc.equalsIgnoreCase("TOAddrInit")) {
			return mapping.findForward("TOAddr");
		}
		if (fc.equalsIgnoreCase("CCAddrInit")) {
			return mapping.findForward("CCAddr");
		}
		if (fc.equalsIgnoreCase("BCCAddrInit")) {
			return mapping.findForward("BCCAddr");
		}
		if (fc.equalsIgnoreCase("new")||fc.equalsIgnoreCase("re")||fc.equalsIgnoreCase("reall")||fc.equalsIgnoreCase("fw")) {
			rc = processMailInput(form,newMail);
			String submit = form.getString("submit");
			Log.trace("submit="+submit);
			if (submit.indexOf("M")>=0) {
				if (rc==false) {
					ActionMessages amsgError = new ActionMessages();
					ActionMessage msg = new ActionMessage("errors.email.void");
					amsgError.add(ActionMessages.GLOBAL_MESSAGE, msg);
					saveErrors(request, amsgError);
					request.setAttribute("sendMail",newMail);
					if (fc.equalsIgnoreCase("new")){
						return mapping.findForward("NewMail");
					}else if (fc.equalsIgnoreCase("re")){
						return mapping.findForward("ReplyMail");
					}else if (fc.equalsIgnoreCase("fw")){
						return mapping.findForward("FwMail");
					}
					return mapping.findForward("error");
				}
				return sendMail(env,form,mapping,newMail,request,fc,forward);
			}
			else if (submit.indexOf("[]")>=0) {
				return mapping.findForward("TOAddr");
			}
			else if (submit.indexOf("[CC]")>=0) {
				return mapping.findForward("CCAddr");
			}
			else if (submit.indexOf("[BCC]")>=0) {
				return mapping.findForward("BCCAddr");
			}
			return mapping.findForward("error");
		}
		return mapping.findForward("error");
	}

	/**
	 * @param request
	 * @param mapping
	 * @param returnPath
	 * @return
	 * @throws Exception
	 */
	private ActionForward searchMailAddress(CommandEnvSet env,HttpServletRequest request, ActionMapping mapping, String returnPath) throws Exception
	{
		String name = env.getString("name");
		int select = ((Integer)env.get("select")).intValue();
		setList(env,request,searchServerAddressbook(env,name,select));
		StrutsArrayList list = (StrutsArrayList)request.getAttribute("list");
		int size = list.size();
		if (size > 20) {
			request.setAttribute("message", "܂Bi荞łB");
		}
		return mapping.findForward(returnPath);
	}

	/**
	 * @param mapping
	 * @param request
	 * @param fc
	 * @return
	 */
	private ActionForward sendMail(CommandEnvSet env,DynaActionForm form,ActionMapping mapping,WebMailParseHelper newMail, HttpServletRequest request, String fc, String forward) throws Exception
	{
		String fromString=null;
		if (fromString==null) {
			fromString="";
		}
		Log.debug("from:"+fromString);
		newMail.setFrom(fromString);
		String body = newMail.getBody();
		String quatation = form.getString("q");
		if (quatation!=null) {
			if (quatation.equals("y")) {
				body = body + newMail.getOriginalBody();
			}
		}
		Log.debug("body="+body);
		newMail.setBody(body);

		try {
			ctrl.sendMail(env.getString("u"),env.getString("p"),newMail.getMail());
		}
		catch (HandleException e) {
			String message = e.getMessage();
			if (message.indexOf("4294") >= 0) {
				ActionMessages amsgError = new ActionMessages();
				ActionMessage msg = new ActionMessage("errors.email.address");
				amsgError.add(ActionMessages.GLOBAL_MESSAGE, msg);
				saveErrors(request, amsgError);
				request.setAttribute("sendMail",newMail);
				if (fc.equalsIgnoreCase("new")){
					return mapping.findForward("NewMail");
				}else if (fc.equalsIgnoreCase("re")){
					return mapping.findForward("ReplyMail");
				}else if (fc.equalsIgnoreCase("fw")){
					return mapping.findForward("FwMail");
				}
				return mapping.findForward("error");
			}
			Log.error("", e);
			return mapping.findForward("authError");
		}
		catch(Exception e) {
			Log.error("", e);
			return mapping.findForward("authError");
		}
		return mapping.findForward(forward);
	}

	/**
	 * @param form
	 * @param env
	 */
	private boolean processMailInput(DynaActionForm form,WebMailParseHelper newMail)
	{
		boolean rc = true;
		String[] toArray = makeArray(form.getString("TO"));
		Log.debug("to[]:"+Arrays.asList(toArray));

		newMail.setTO(toArray);

		String[] ccArray = makeArray(form.getString("CC"));
		Log.debug("cc[]:"+Arrays.asList(ccArray));

		newMail.setCC(ccArray);

		String bcc = form.getString("BCC").trim();
		if (bcc.endsWith(",")) {
			bcc = bcc.substring(0,bcc.length()-1);
		}
		String[] bccArray = makeArray(bcc);
		Log.debug("bcc[]:"+Arrays.asList(bccArray));

		newMail.setBCC(bccArray);

		newMail.setSubject(form.getString("subject"));
		String body=form.getString("body");
		newMail.setBody(body);

		if (toArray.length==0 && ccArray.length==0 && bccArray.length==0) {
			rc = false;
		}
		return rc;
	}


	private boolean processScheduleInput(DynaActionForm form,
			WebScheduleParseHelper newSche, HttpServletRequest request)
	{
		boolean rc = true;
		newSche.setSubject(form.getString("subject"));
		newSche.setBody(form.getString("body"));
		newSche.setLocation(form.getString("location"));

		String startDateStr = form.getString("startDate");
		if (startDateStr.length() != 8) {
			createErrorMessage("errors.schedule.invalidStartDateForm", request);
			return false;
		}
		try {
			Integer.parseInt(startDateStr);
		} catch (NumberFormatException e) {
			createErrorMessage("errors.schedule.invalidStartDateForm", request);
			return false;
		}
		String startTimeStr = form.getString("startHour");
		if (startTimeStr.length() != 4) {
			createErrorMessage("errors.schedule.invalidStartTimeForm", request);
			return false;
		}
		try {
			Integer.parseInt(startTimeStr);
		} catch (NumberFormatException e) {
			createErrorMessage("errors.schedule.invalidStartTimeForm", request);
			return false;
		}
		String startDateTimeStr = startDateStr+startTimeStr;
		Date startDate = DateControler.getDateFromStr(startDateTimeStr);
		newSche.setStartDate(startDate);

		String endDateStr = form.getString("endDate");
		if (endDateStr.length() != 8) {
			createErrorMessage("errors.schedule.invalidEndDateForm", request);
			return false;
		}
		try {
			Integer.parseInt(endDateStr);
		} catch (NumberFormatException e) {
			createErrorMessage("errors.schedule.invalidEndDateForm", request);
			return false;
		}
		String endTimeStr = form.getString("endHour");
		if (endTimeStr.length() != 4) {
			createErrorMessage("errors.schedule.invalidEndTimeForm", request);
			return false;
		}
		try {
			Integer.parseInt(endTimeStr);
		} catch (NumberFormatException e) {
			createErrorMessage("errors.schedule.invalidEndTimeForm", request);
			return false;
		}
		String endDateTimeStr = endDateStr+endTimeStr;
		Date endDate = DateControler.getDateFromStr(endDateTimeStr);
		newSche.setEndDate(endDate);

		if (endDate.compareTo(startDate) < 0) {
			createErrorMessage("errors.schedule.invalidDate", request);
			return false;
		}

		return rc;
	}
	private void createErrorMessage(String message, HttpServletRequest request) {
		ActionMessages amsgError = new ActionMessages();
		ActionMessage msg = new ActionMessage(message);
		amsgError.add(ActionMessages.GLOBAL_MESSAGE, msg);
		saveErrors(request, amsgError);
	}

	private void mailAttrsSet(CommandEnvSet env,HttpServletRequest request, WebMailParseHelper mail)
	{
		Integer currentPage = (Integer)env.get("cp");
		mail.setCurrentPage(currentPage.intValue());
		request.setAttribute("mail",mail);
		IndexList idxList = (IndexList)env.get("nList");
		int max = idxList.size();
		Integer Idx = (Integer)env.get("midx");
		int idx = Idx.intValue();
		if ((idx+1) < max) {
			request.setAttribute("nextIdx",new Integer(idx+1));
		}
		if (idx>0) {
			request.setAttribute("prevIdx",new Integer(idx-1));
		}
		env.put("nmail",mail);
		env.put("cacheIdx",Idx);
	}

	private void mailAttachmentSet(CommandEnvSet env,HttpServletRequest request, DhkWebAttachmentParseHelper att)
	{
		Integer currentPage = (Integer)env.get("cp");
		att.setCurrentPage(currentPage.intValue());
		ServletContext ctx = getServlet().getServletContext();
		String path = ctx.getRealPath("");
		att.setAbsolutePath(path);
		env.put("attach",att);
		request.setAttribute("attach",att);

	}

	private void addrAttrsSet(CommandEnvSet env,HttpServletRequest request, WebAddressParseHelper addr)
	{
		request.setAttribute("address",addr);
		IndexList idxList = (IndexList)env.get("nList");
		int max = idxList.size();
		Integer Idx = (Integer)env.get("midx");
		int idx = Idx.intValue();
		if ((idx+1) < max) {
			request.setAttribute("nextIdx",new Integer(idx+1));
		}
		if (idx>0) {
			request.setAttribute("prevIdx",new Integer(idx-1));
		}
		env.put("naddress",addr);
		env.put("cacheIdx",Idx);
	}

	private void scheduleAttrsSet(CommandEnvSet env,HttpServletRequest request, WebScheduleParseHelper sche)
	{
		Log.debug("scheduleAttrsSet:schedule="+sche);
		Log.debug("scheduleAttrsSet:subject="+sche.getSubject());
		request.setAttribute("schedule",sche);
		IndexList idxList = (IndexList)env.get("nList");
		int max = idxList.size();
		Integer Idx = (Integer)env.get("midx");
		int idx = Idx.intValue();
		if ((idx+1) < max) {
			request.setAttribute("nextIdx",new Integer(idx+1));
		}
		if (idx>0) {
			request.setAttribute("prevIdx",new Integer(idx-1));
		}
		env.put("nschedule",sche);
		env.put("cacheIdx",Idx);
	}

	private ActionForward processInboxMail(CommandEnvSet env,ActionMapping mapping, HttpServletRequest request, String fc, Date date) throws Exception
	{
		if (fc.equalsIgnoreCase(FC_ATT)) {
			DhkWebAttachmentParseHelper att;
			WebMailParseHelper mail = (WebMailParseHelper)env.get("nmail");
			if (mail == null) {
				mail = getMail(env);
			}
			Integer aidx = (Integer)env.get("aidx");
			IMailDTO dto = mail.getMail();
			if (dto.getNumberOfAttachments()>0) {
				att = new DhkWebAttachmentParseHelper(dto.getAttachment(aidx.intValue()));
				att.setBodyLength(mail.getBodyLength());
				mailAttachmentSet(env, request, att);
			}
			return mapping.findForward("Attachment");
		}
		if (fc.equalsIgnoreCase(FC_VIEW)) {
			WebMailParseHelper mail = (WebMailParseHelper)env.get("nmail");
			if (mail != null) {
				if(attachmentsContainsNull(mail)){
					Log.warn("Attachment is empty.");
				}
				Integer cacheIdx = (Integer)env.get("cacheIdx");
				Integer idx = (Integer)env.get("midx");
				if (idx.equals(cacheIdx)) {
					mailAttrsSet(env,request, mail);
					int cp = ((Integer)env.get("cp")).intValue();
					if (cp>0) {
						return mapping.findForward("Mail2");
					}
					return mapping.findForward("InboxMail");
				}
			}
			mail = getMail(env);
			if(attachmentsContainsNull(mail)){
				Log.warn("Attachment is empty.");
			}
			mailAttrsSet(env,request, mail);
			return mapping.findForward("InboxMail");
		}
		if (fc.equalsIgnoreCase(FC_LIST)) {
			if (!(dateValidate(date,env.getString("date")))) {
				ActionMessages errors = new ActionMessages();
				ActionMessage mess =  new ActionMessage("errors.invalid","t");
				errors.add("error.maildate.format",mess);
				saveErrors(request, errors);
				date = new Date();// set today..as default.
				request.setAttribute("date",date);
			}

			env.put("cacheIdx",null);

			Integer cp = (Integer)env.get("cp");
			setCmdCache(request.getSession(),CMD_INBOX_MAIL,null,cp);

			setList(env,request,getAllMails(env,null,date));
			return mapping.findForward("Inbox");
		}
		if (fc.equalsIgnoreCase(FC_HEAD)) {
			env.put("cacheIdx",null);
			WebMailParseHelper mail = (WebMailParseHelper)env.get("nmail");
			request.setAttribute("mail",mail);
			return mapping.findForward("MailHeader");
		}
		if (fc.equalsIgnoreCase(FC_DELCHECK)) {
			env.put("cacheIdx",null);
			return mapping.findForward("MailDelCheck");
		}
		if (fc.equalsIgnoreCase(FC_DEL)) {
			if (checkDeleteIgnore(env)) {
				WebMailParseHelper mail = (WebMailParseHelper)env.get("nmail");
				mailAttrsSet(env,request, mail);
				return mapping.findForward("InboxMail");
			}
			env.put("cacheIdx",null);
			env.put("cp",null);
			env.put("date",null);
			deleteMail(env);
			return mapping.findForward("nMenu");
		}
		env.put("cacheIdx",null);
		return mapping.findForward("error");
	}

	private ActionForward processFolderMail(CommandEnvSet env,ActionMapping mapping, HttpServletRequest request, String fc, Date date) throws Exception
	{
		if (fc.equalsIgnoreCase(FC_ATT)) {
			DhkWebAttachmentParseHelper att;
			WebMailParseHelper mail = (WebMailParseHelper)env.get("nmail");
			if (mail == null) {
				mail = getMail(env);
			}
			Integer aidx = (Integer)env.get("aidx");
			IMailDTO dto = mail.getMail();
			if (dto.getNumberOfAttachments()>0) {
				att = new DhkWebAttachmentParseHelper(dto.getAttachment(aidx.intValue()));
				att.setBodyLength(mail.getBodyLength());
				mailAttachmentSet(env, request, att);
			}
			return mapping.findForward("Attachment");
		}
		if (fc.equalsIgnoreCase(FC_VIEW)) {
			WebMailParseHelper mail = (WebMailParseHelper)env.get("nmail");
			if (mail != null) {
				if(attachmentsContainsNull(mail)){
					Log.warn("Attachment is empty.");
				}
				Integer cacheIdx = (Integer)env.get("cacheIdx");
				Integer idx = (Integer)env.get("midx");
				if (idx.equals(cacheIdx)) {
					mailAttrsSet(env,request, mail);
					int cp = ((Integer)env.get("cp")).intValue();
					if (cp>0) {
						return mapping.findForward("Mail2");
					}
					return mapping.findForward("InboxMail");
				}
			}
			mail = getMail(env);
			if(attachmentsContainsNull(mail)){
				Log.warn("Attachment is empty.");
			}
			mailAttrsSet(env,request, mail);
			return mapping.findForward("InboxMail");
		}
		if (fc.equalsIgnoreCase(FC_FLIST)) {
			env.put("cacheIdx",null);
			setList(env,request,getMailFolderList(env,request));
			return mapping.findForward("MailFolder");
		}
		if (fc.equalsIgnoreCase(FC_LIST)) {
			if (!(dateValidate(date,env.getString("date")))) {
				ActionMessages errors = new ActionMessages();
				ActionMessage mess =  new ActionMessage("errors.invalid","t");
				errors.add("error.maildate.format",mess);
				saveErrors(request, errors);
				date = new Date();// set today..as default.
				request.setAttribute("date",date);
			}


			env.put("cacheIdx",null);

			//tH_̖OƃCfbNX
			Integer idx = (Integer)env.get("fidx");
			StrutsArrayList list = (StrutsArrayList)request.getSession().getAttribute("nFolderList");
			FolderMetadata folder = (FolderMetadata)list.get(idx.intValue());
			String fname = folder.getFolderName();
			IFolderIndex fid = (IFolderIndex)folder.getOid();

			Integer cp = (Integer)env.get("cp");
			setCmdCache(request.getSession(),CMD_FOLDER_MAIL,idx,cp);

			setList(env,request,getAllMails(env,fid,date));
			request.setAttribute("name", fname);
			return mapping.findForward("MailList");
		}
		if (fc.equalsIgnoreCase(FC_HEAD)) {
			env.put("cacheIdx",null);
			WebMailParseHelper mail = (WebMailParseHelper)env.get("nmail");
			request.setAttribute("mail",mail);
			return mapping.findForward("MailHeader");
		}
		if (fc.equalsIgnoreCase(FC_DELCHECK)) {
			env.put("cacheIdx",null);
			return mapping.findForward("MailDelCheck");
		}
		if (fc.equalsIgnoreCase(FC_DEL)) {
			if (checkDeleteIgnore(env)) {
				WebMailParseHelper mail = (WebMailParseHelper)env.get("nmail");
				mailAttrsSet(env,request, mail);
				return mapping.findForward("InboxMail");
			}
			env.put("cacheIdx",null);
			env.put("cp",null);
			env.put("date",null);
			deleteMail(env);
			return mapping.findForward("nMenu");
		}
		env.put("cacheIdx",null);
		return mapping.findForward("error");
	}
	private ActionForward processSentMail(CommandEnvSet env,ActionMapping mapping, HttpServletRequest request, String fc, Date date) throws Exception
	{
		if (fc.equalsIgnoreCase(FC_VIEW)) {
			WebMailParseHelper mail = (WebMailParseHelper)env.get("nmail");
			if (mail != null) {
				Integer cacheIdx = (Integer)env.get("cacheIdx");
				Integer idx = (Integer)env.get("midx");
				if (idx.equals(cacheIdx)) {
					mailAttrsSet(env,request, mail);
					int cp = ((Integer)env.get("cp")).intValue();
					if (cp>0) {
						return mapping.findForward("SentMail2");
					}
					return mapping.findForward("SentMail");
				}
			}
			mail = getMail(env);
			mailAttrsSet(env,request, mail);
			return mapping.findForward("SentMail");
		}
		if (fc.equalsIgnoreCase(FC_LIST)) {
			env.put("cacheIdx",null);

			Integer cp = (Integer)env.get("cp");
			setCmdCache(request.getSession(),CMD_SENT_MAIL,null,cp);

			setList(env,request,getAllSentMails(env,date));
			return mapping.findForward("Sentbox");
		}
		if (fc.equalsIgnoreCase(FC_HEAD)) {
			env.put("cacheIdx",null);
			WebMailParseHelper mail = (WebMailParseHelper)env.get("nmail");
			request.setAttribute("mail",mail);
			return mapping.findForward("MailHeader");
		}
		if (fc.equalsIgnoreCase(FC_DELCHECK)) {
			env.put("cacheIdx",null);
			return mapping.findForward("MailDelCheck");
		}
		if (fc.equalsIgnoreCase(FC_DEL)) {
			if (checkDeleteIgnore(env)) {
				WebMailParseHelper mail = (WebMailParseHelper)env.get("nmail");
				mailAttrsSet(env,request, mail);
				return mapping.findForward("SentMail");
			}
			env.put("cacheIdx",null);
			env.put("cp",null);
			env.put("date",null);
			deleteMail(env);
			return mapping.findForward("nMenu");
		}
		env.put("cacheIdx",null);
		return mapping.findForward("error");
	}

	void setList(CommandEnvSet env,HttpServletRequest request,StrutsArrayList list)
	{
		HttpSession session=request.getSession(true);
		Integer cp = (Integer)env.get("cp");
		if (cp != null) {
			list.setCurrentPage(cp.intValue());
		}
		if (list.size()==0) {
			request.setAttribute("list",list);
			return;
		}
		IRecordObject sample = (IRecordObject)list.get(0);
		if (sample instanceof FolderMetadata) {
			session.setAttribute("nFolderList",list);
		}
		else {
			env.put("nList",list.getIdxList());
		}
		request.setAttribute("list",list);
	}

	boolean setCalender(CommandEnvSet env,HttpServletRequest request) throws Exception //TODO mnishikawa inos 2008/09/30 add
	{
		boolean hasError=false;
		String dateStr = env.getString("date");
		Date date = (Date)request.getAttribute("date");
		ActionMessages amsgError = new ActionMessages();
		ActionMessage msg = null;
		if(dateStr!=null && date!=null){
			DateControler dc = new DateControler(date);
			if(!dateStr.equals(dc.getDateStr())){
				date = new Date();
				msg = new ActionMessage("errors.invalid","t");
				amsgError.add(ActionMessages.GLOBAL_MESSAGE,msg);
				saveErrors(request,amsgError);
				hasError=true;
			}
		}
		else if(dateStr!=null && date==null){
			date = new Date();
			msg = new ActionMessage("errors.invalid","t");
			amsgError.add(ActionMessages.GLOBAL_MESSAGE,msg);
			saveErrors(request,amsgError);
			hasError=true;
		}
		else {
			return false;
		}
		request.setAttribute("date",date);
		DateControler dc = new DateControler(date);
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		int weekInt = cal.get(Calendar.DAY_OF_WEEK);


		List<Date> week1 = new ArrayList<Date>();
		List<Date> week2 = new ArrayList<Date>();

		int count=0;
		switch(weekInt){
		case Calendar.MONDAY:
			break;
		case Calendar.TUESDAY:
			count = 1;
			break;
		case Calendar.WEDNESDAY:
			count = 2;
			break;
		case Calendar.THURSDAY:
			count = 3;
			break;
		case Calendar.FRIDAY:
			count = 4;
			break;
		case Calendar.SATURDAY:
			count = 5;
			break;
		case Calendar.SUNDAY:
			count = 6;
			break;
		}
		for(int i=0;i<count;i++){
			dc = new DateControler(dc.getPrevDateStr());
		}

		DateControler dc2 = new DateControler(dc.getDate());
		for(int i=0;i<7;i++){
			dc2 = new DateControler(dc2.getPrevDateStr());
		}
		request.setAttribute("prevWeek", dc2.getDate());

		for(int i=0;i<7;i++){
			week1.add(i, dc.getDate());
			dc = new DateControler(dc.getNextDateStr());
		}
		for(int i=0;i<7;i++){
			if(i==0)
				request.setAttribute("nextWeek", dc.getDate());
			week2.add(i, dc.getDate());
			dc = new DateControler(dc.getNextDateStr());
		}
		request.setAttribute("week1", week1);
		request.setAttribute("week2", week2);
		return hasError;
	}

	private void deleteMail(CommandEnvSet env) throws Exception
	{
		WebMailParseHelper o = (WebMailParseHelper)env.get("nmail");
		IObjectIndex mid = o.getOid();
		ctrl.delete(env.getString("u"),env.getString("p"),mid);
	}

	private void deleteSchedule(CommandEnvSet env) throws Exception
	{
		WebScheduleParseHelper o = (WebScheduleParseHelper)env.get("nschedule");
		IObjectIndex mid = o.getOid();
		ctrl.delete(env.getString("u"),env.getString("p"),mid);
	}

	private WebMailParseHelper getMail(CommandEnvSet env) throws Exception
	{
		Integer idx = (Integer)env.get("midx");
		IndexList idxList = (IndexList)env.get("nList");
		IObjectIndex mid = (IObjectIndex)idxList.get(idx.intValue());
		return ctrl.getMail(env.getString("u"),env.getString("p"),mid);
	}

	private WebScheduleParseHelper getSchedule(CommandEnvSet env) throws Exception
	{
		Integer idx = (Integer)env.get("midx");
		IndexList idxList = (IndexList)env.get("nList");
		IObjectIndex mid = (IObjectIndex)idxList.get(idx.intValue());
		return ctrl.getSchedule(env.getString("u"),env.getString("p"),mid);
	}

	private StrutsArrayList getAllMails(CommandEnvSet env,IFolderIndex fid,Date date) throws Exception
	{

		StrutsArrayList rc = ctrl.getMailList(env.getString("u"),env.getString("p"),fid,date);
		int ps = rc.getPageSize();

		NotesMailParseHelperComparator c = new NotesMailParseHelperComparator(NotesMailParseHelperComparator.RECEIVEDDATE,true);
		WebMailParseHelper a[] = new WebMailParseHelper[0];
		a = rc.toArray(a);
		return sortList(ps, c, a);
	}

	private StrutsArrayList getAllSentMails(CommandEnvSet env,Date date) throws Exception
	{

		StrutsArrayList rc = ctrl.getSentMailList(env.getString("u"),env.getString("p"),null,date);
		int ps = rc.getPageSize();

		NotesMailParseHelperComparator c = new NotesMailParseHelperComparator(NotesMailParseHelperComparator.RECEIVEDDATE,true);
		WebMailParseHelper a[] = new WebMailParseHelper[0];
		a = rc.toArray(a);
		return sortList(ps, c, a);
	}

	@SuppressWarnings("unchecked")
	private StrutsArrayList sortList(int ps, Comparator c, IRecordObject[] a)
	{
		StrutsArrayList rc;
		Arrays.sort(a,c);
		List<IRecordObject> b = Arrays.asList(a);
		rc = new StrutsArrayList();
		rc.addAll(b);
		rc.setPageSize(ps);
		return rc;
	}

	StrutsArrayList getMailFolderList(CommandEnvSet env, HttpServletRequest request) throws Exception
	{
		StrutsArrayList rc = ctrl.getMailFolderList(env.getString("u"),env.getString("p"));
		List<IRecordObject> removeList = new ArrayList<IRecordObject>();
		for(int i=0;i<rc.size();i++){
			IRecordObject iro = rc.get(i);
			if(iro instanceof FolderMetadata){
				FolderMetadata folder = (FolderMetadata)iro;
				String fname = folder.getFolderName();
				if(fname.startsWith("(")){
					removeList.add(iro);
					continue;
				}
			}
		}
		rc.removeAll(removeList);
		for(int i=0;i<rc.size()-1;i++){
			for(int j=i+1;j<rc.size();j++){
				IRecordObject iro = rc.get(i);
				IRecordObject iro2 = rc.get(j);
				if(iro instanceof FolderMetadata && iro2 instanceof FolderMetadata){
					FolderMetadata folder = (FolderMetadata)iro;
					FolderMetadata folder2 = (FolderMetadata)iro2;
					String fname = folder.getFolderName();
					String fname2 = folder2.getFolderName();
					String[] splitFolderName = fname.split("\\u005c");
					String[] splitFolderName2 = fname2.split("\\u005c");
					int layerNum = splitFolderName.length;
					int layerNum2 = splitFolderName2.length;
					for(int k=0;k<layerNum && k<layerNum2;k++){
						if(splitFolderName2[k].compareTo(splitFolderName[k])<0){
							rc.set(i,iro2);
							rc.set(j,iro);
							break;
						}
					}
				}
			}
		}
		List<String> intendList = new ArrayList<String>();
		for(int i=0;i<rc.size();i++){
			IRecordObject iro = rc.get(i);
			if(iro instanceof FolderMetadata){
				FolderMetadata folder = (FolderMetadata)iro;
				String fname = folder.getFolderName();
				String[] splitFolderName = fname.split("\\u005c");
				int layerNum = splitFolderName.length;
				folder.setFolderName(splitFolderName[layerNum-1]);
				StringBuffer sb = new StringBuffer("");
				if(layerNum==1){
					sb.append("");
				}
				else{
					sb.append("|-");
				}
				for(int j=1;j<layerNum;j++){
					sb.insert(0,"@");
				}
				intendList.add(sb.toString());
			}
		}
		intendList.add(0,"");
		intendList.add(1,"");
		request.setAttribute("intendList", intendList);
		FolderMetadata sent = new FolderMetadata();
		sent.setOid(new NotesFolderIndex(NotesMailStoreImpl.DEFAULT_NOTES_SENTBOX_NAME));
		sent.setFolderName("Mς݃ACe");
		rc.add(0,sent);
		FolderMetadata inbox = new FolderMetadata();
		inbox.setOid(new NotesFolderIndex(NotesMailStoreImpl.DEFAULT_NOTES_INBOX_NAME));
		inbox.setFolderName("MgC");
		rc.add(1,inbox);

		int ps = rc.getPageSize();
		Comparator<IRecordObject> c = new Comparator<IRecordObject>() {
			public int compare(IRecordObject o1,IRecordObject o2) {
				return 0;
			}
		};
		IRecordObject a[] = new IRecordObject[0];
		a = rc.toArray(a);
		return sortList(ps, c, a);
	}

	private WebAddressParseHelper getAddressBookItem(CommandEnvSet env,String addressType) throws Exception
	{
		Integer idx = (Integer)env.get("midx");
		IndexList idxList = (IndexList)env.get("nList");
		IObjectIndex mid = (IObjectIndex)idxList.get(idx.intValue());
		int mode=0;
		if (addressType.equalsIgnoreCase("g")) {
			mode = Controler.COMMON_ADDRESSBOOK;
		}
		else {
			mode = Controler.PERSONAL_ADDRESSBOOK;
		}
		return ctrl.getAddressBookItem(env.getString("u"),env.getString("p"),mid,mode);
	}

	private StrutsArrayList getAllSchedules(CommandEnvSet env,Date date) throws Exception
	{
		StrutsArrayList rc = ctrl.getScheduleList(env.getString("u"),env.getString("p"),date);
		int ps = rc.getPageSize();
		IScheduleDTOComparator c = new IScheduleDTOComparator(IScheduleDTOComparator.STARTDATETIME,false);
		IScheduleDTO a[] = new IScheduleDTO[0];
		a = (IScheduleDTO[])rc.toArray(a);
		return sortList(ps, c, a);
	}

	private StrutsArrayList searchServerAddressbook(CommandEnvSet env,String name,int select) throws Exception
	{
		StrutsArrayList rc = ctrl.searchAddress(env.getString("u"),env.getString("p"),name,Controler.COMMON_ADDRESSBOOK,select);
		int ps = 20;
		IAddressDTOComparator c = new IAddressDTOComparator(IAddressDTOComparator.DISPLAYNAME,false);
		IAddressDTO a[] = new IAddressDTO[0];
		a = (IAddressDTO[])rc.toArray(a);
		return sortList(ps, c, a);
	}

	private boolean checkDeleteIgnore(CommandEnvSet env)
	{
		String submit = env.getString("submit");
		if ("폜".equals(submit)) return false;
		return true;
	}
	private boolean attachmentsContainsNull(WebMailParseHelper mail) throws Exception
	{
		if(mail == null) {
			throw new NullPointerException("mail must not be null");
		}
		if(mail.getAttachmentCollection() == null) {
			return false;
		}
		Iterator<AttachmentDTO> ite = mail.getAttachmentCollection().iterator();
		while(ite.hasNext()) {
			if(ite.next() == null) {
				return true;
			}
		}
		return false;
	}
	private void setCmdCache(HttpSession session,String cmd,Integer idx,Integer cp)
	{
		if (session==null) return;
		session.setAttribute("cache_return_cmd", cmd);
		if (idx!=null) {
			session.setAttribute("cache_return_idx", idx);
		}
		if (cp!=null) {
			session.setAttribute("cache_return_cp", cp);
		} else {
			session.setAttribute("cache_return_cp", new Integer(0));
		}
	}
}
