/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.test;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;

import jp.co.connectone.eai.exchews.store.*;
import jp.co.connectone.eai.exchews.user.*;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.user.*;
import junit.framework.TestCase;
/**
 * @author amanot
 *
 */
public class TestExchewsTaskImpl extends TestCase {
	private ExchewsTaskStoreImpl taskStore;
	private ExchewsAccountData acc = null;
	/* ( Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		taskStore = new ExchewsTaskStoreImpl();
		ExchewsServiceInfo info = (ExchewsServiceInfo)taskStore.getServiceInfo();
		IUserKey uid = new BasicUserKey(String.class.getName(), "test");
		info.setServerAddress("exchange");
		info.setProtocolPrefix("https://");
		acc = new ExchewsAccountData(uid, info);
		acc.setUserID("test");
		acc.setPassword("********");
		acc.setDomain("TEST");
	}
	/* ( Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		taskStore = null;
	}

	public void testCreateNewTask() throws Exception
	{
		assertNotNull(taskStore);
		ITaskDTO task = new ExchewsTaskDTO();
		task.setSenderName("test@amax.co.jp");
		task.setBody("ڂł[ł񂪂ȁB");
		task.setSubject("薼");
		
		Object oid = taskStore.createNewTask(acc,task);
		Log.debug(oid.toString());
	}

	public void testGetTasks() throws Exception
	{
		assertNotNull(taskStore);
		ITaskDTO[] h = taskStore.getAllTasks(acc);
		assertNotNull(h);
		assertTrue(h.length>0);
		assertFalse(h[0].isNew());
		for (int i=0;i<h.length;i++) {
			dumpDTO(h[i]);
		}
	}
	
	public void testGetTask() throws Exception
	{
		String id = "AAMkADFhNGI3N2Q0LWRkNWItNDBhNy04ODIyLWUyMjYxNGU1MzE2ZgBGAAAAAAByYJ+pxeduSYit4EQVkQLFBwDAyRCo9hqpT60LcrpLV3HzAAALPsN0AAC994qxD0rdTLqAc+xnPTyTAAANdhABAAA=";
		ExchewsObjectIndex oid = ExchEWSTranslator.createIndex(id);
		assertNotNull(taskStore);
		ExchewsTaskDTO task = (ExchewsTaskDTO)taskStore.getTaskByOID(acc, oid);
		assertNotNull(task);
		assertNotNull(task.getBody());
		assertTrue(task.getBody().length()>0);
		assertFalse(task.isNew());
		assertTrue(task instanceof ExchewsTaskDTO);
		dumpDTO(task);
	}
	
	public void testUpdateTask() throws Exception
	{
		assertNotNull(taskStore);
		ExchewsTaskDTO task = new ExchewsTaskDTO();
		task.setBody("ڂł[B");
		task.setSubject("updateeXgp");
		
		boolean catchException=false;
		try {
			taskStore.updateTask(acc,task);
		}
		catch (Exception e) {
			catchException=true;
		}
		finally {
			assertTrue(catchException);
		}
		catchException=false;
		
		IObjectIndex oid = taskStore.createNewTask(acc,task);
		assertNotNull(oid);
		task.setOid(oid);
		
		task.setBody("updateꂽ{fB[łB");
		
		try {
			taskStore.updateTask(acc, task);
		}
		catch (Exception e) {
			catchException=true;
		}
		finally {
			assertFalse(catchException);
		}
		
		ITaskDTO task2 = taskStore.getTaskByOID(acc, oid);
		assertEquals(task2.getSubject(), "updateeXgp");
		assertEquals(task2.getBody(), "updateꂽ{fB[łB");
	}
	
	public void testDeleteTask() throws Exception
	{
		String id = "AAMkADFhNGI3N2Q0LWRkNWItNDBhNy04ODIyLWUyMjYxNGU1MzE2ZgBGAAAAAAByYJ+pxeduSYit4EQVkQLFBwDAyRCo9hqpT60LcrpLV3HzAAALPsN0AAAOvrSTFzPIQ5PjycGgMJFGAGwwSUIsAAA=";
		ExchewsObjectIndex oid = ExchEWSTranslator.createIndex(id);
		assertNotNull(taskStore);
		boolean catchException=false;
		try {
			taskStore.deleteTask(acc, oid);
		}
		catch (IncorrectData icd) {
			catchException=true;
		}
		finally {
			assertTrue(catchException);
		}
		catchException=false;

		ITaskDTO task = new ExchewsTaskDTO();
		task.setSenderName("test@amax.co.jp");
		task.setBody("폜eXgṕudvłB");
		task.setSubject("폜eXgp");
		
		IObjectIndex idForDelete = taskStore.createNewTask(acc,task);
		try {
			taskStore.deleteTask(acc, idForDelete);
		}
		catch (IncorrectData icd) {
			catchException=true;
		}
		finally {
			assertFalse(catchException);
		}
		
	}
	
	private void dumpDTO(ITaskDTO dto)
	{
		Log.debug("============================");
		Log.debug("oid:"+((ItemIdType)dto.getOid().getIndex()).getId());
		Log.debug(dto.getSubject());
		Log.debug(dto.getBody());
		Log.debug(dto.getSenderName());
	}
}
