/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.store;

import java.util.*;

import com.microsoft.schemas.exchange.services._2006.types.ArrayOfRecipientsType;
import com.microsoft.schemas.exchange.services._2006.types.ItemIdType;
import com.microsoft.schemas.exchange.services._2006.types.MessageType;

import jp.co.connectone.eai.exchews.ews.IEwsDTOType;
import jp.co.connectone.eai.exchews.util.ExchEWSImportance;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.store.pim.*;

/**
 * @author amanot
 * 
 */
public class ExchewsMailDTO extends ExchewsItemBase implements IMailDTO,IEwsDTOType
{
	private static final long serialVersionUID = 1L;

	protected MailAddress sender;
	protected MailAddress[] toRecipients;
	protected MailAddress[] ccRecipients;
	protected MailAddress[] bccRecipients;
	protected boolean isReadReceiptRequested;
	protected boolean isDeliveryReceiptRequested;
	protected byte[] conversationIndex;
	protected String conversationTopic;
	protected MailAddress from;
	protected String internetMessageId;
	protected boolean read;
	protected boolean isResponseRequested;
	protected String references;
	protected MailAddress replyTo;
	protected MailAddress receivedBy;
	protected MailAddress receivedRepresenting;
	
	protected String[] MailItemNameList = {
		    "sender",
		    "toRecipients",
		    "ccRecipients",
		    "bccRecipients",
		    "isReadReceiptRequested",
		    "isDeliveryReceiptRequested",
		    "conversationIndex",
		    "conversationTopic",
		    "from",
		    "internetMessageId",
		    "isRead",
		    "isResponseRequested",
		    "references",
		    "replyTo",
		    "receivedBy",
		    "receivedRepresenting"
	};
	
	
	protected AttachmentDTO[] attachments;
	
	public ExchewsMailDTO(IMailDTO dto)
	{
		if (dto==null)return;
		setHeaderDTO(dto.getHeader());
		super.body = dto.getBody();
		super.attachments = dto.getAttachments();
	}
	
	public ExchewsMailDTO(HeaderDTO header)
	{
		setHeaderDTO(header);
	}

	public ExchewsMailDTO()
	{
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see
	 * jp.co.connectone.store.client.BasicMailDTO#setHeaderDTO(jp.co.connectone
	 * .store.client.HeaderDTO)
	 */
	public void setHeaderDTO(HeaderDTO header)
	{
		if (header != null) {
			copyHeader(header);
		}
	}

	@Override
	public HeaderDTO getHeader()
	{
		return generateHeader();
	}

	/* original functions */
	public void copyExch2kElements2Header()
	{
//		header.setHeaderFrom(from);
//		header.setHeaderTo(parseAddresses(to));
//		header.setHeaderCC(parseAddresses(cc));
//		header.setHeaderBCC(parseAddresses(bcc));
//		header.setHeaderReplyTo(reply_to);
//		header.setHeaderSendDate(dateTimeSent);
//		header.setHeaderSubject(subject);
//		if (importance == ExchEWSImportance.LOW) {
//			header.setHeaderPriority(0);
//		}
//		else if (importance == ExchEWSImportance.NORMAL) {
//			header.setHeaderPriority(1);
//		}
//		else if (importance == ExchEWSImportance.HIGH) {
//			header.setHeaderPriority(2);
//		}
	}

	public MailAddress getSender()
	{
		return this.sender;
	}

	public void setSender(MailAddress sender)
	{
		this.sender = sender;
	}

	public boolean isReadReceiptRequested()
	{
		return this.isReadReceiptRequested;
	}

	public void setReadReceiptRequested(boolean isReadReceiptRequested)
	{
		this.isReadReceiptRequested = isReadReceiptRequested;
	}

	public byte[] getConversationIndex()
	{
		return this.conversationIndex;
	}

	public void setConversationIndex(byte[] conversationIndex)
	{
		this.conversationIndex = conversationIndex;
	}

	public String getConversationTopic()
	{
		return this.conversationTopic;
	}

	public void setConversationTopic(String conversationTopic)
	{
		this.conversationTopic = conversationTopic;
	}

	public String getInternetMessageId()
	{
		return this.internetMessageId;
	}

	public void setInternetMessageId(String internetMessageId)
	{
		this.internetMessageId = internetMessageId;
	}

	public boolean isRead()
	{
		return this.read;
	}

	public void setRead(boolean read)
	{
		this.read = read;
	}

	public MailAddress getReceivedBy()
	{
		return this.receivedBy;
	}

	public void setReceivedBy(MailAddress receivedBy)
	{
		this.receivedBy = receivedBy;
	}
	
	private HeaderDTO generateHeader()
	{
		HeaderDTO h = new HeaderDTO();
		h.setHeaderBCC(this.bccRecipients);
		h.setHeaderCC(this.ccRecipients);
		h.setHeaderFrom(this.from);
		h.setHeaderReceivedDate(this.dateTimeReceived);
		h.setHeaderReplyTo(this.replyTo);
		h.setHeaderSendDate(this.dateTimeSent);
		h.setHeaderSize(this.size);
		h.setHeaderSubject(this.subject);
		h.setHeaderTo(this.toRecipients);
		ItemIdType id = (ItemIdType)this.oid.getIndex();
		h.setHeaderUIDL(id.getId());
		h.setOid(this.oid);
		return h;
	}

	private void copyHeader(HeaderDTO h)
	{
		bccRecipients = h.getHeaderBCC();
		ccRecipients = h.getHeaderCC();
		toRecipients = h.getHeaderTo();

		from = h.getHeaderFrom();
		switch (h.getHeaderPriority()) {
		case 0:
			importance = ExchEWSImportance.NORMAL;
			break;
		case 1:
			importance = ExchEWSImportance.HIGH;
			break;
		case -1:
			importance = ExchEWSImportance.LOW;
			break;
		}
		replyTo = h.getHeaderReplyTo();
		subject = h.getHeaderSubject();
		toRecipients = h.getHeaderTo();
	}
	
	public static ExchewsMailDTO convertFromMessageType(MessageType msg) throws Exception
	{
		if (msg == null) return null;
		ExchewsMailDTO rc = new ExchewsMailDTO();
		
		convertFromItemType(rc,msg);

		if (msg.getSender()!=null)rc.setSender(ExchEWSTranslator.convertEWSMailBox2MailAddress(msg.getSender().getMailbox()));
		ArrayOfRecipientsType to_ar = msg.getToRecipients();
		if (to_ar!=null) rc.setTo(ExchEWSTranslator.convertEWSArrayOfRecipientsType2MailBoxes(to_ar));
		ArrayOfRecipientsType cc_ar = msg.getCcRecipients();
		if (cc_ar!=null) rc.setCC(ExchEWSTranslator.convertEWSArrayOfRecipientsType2MailBoxes(cc_ar));
		ArrayOfRecipientsType bcc_ar = msg.getBccRecipients();
		if (bcc_ar!=null) rc.setBCC(ExchEWSTranslator.convertEWSArrayOfRecipientsType2MailBoxes(bcc_ar));
		//rc.setDeliveryReceiptRequested(msg.isIsDeliveryReceiptRequested());
/*
		comment out because of EX2010 SP0 sometime returns null
		rc.setReadReceiptRequested(msg.isIsReadReceiptRequested());
*/
		rc.setConversationIndex(msg.getConversationIndex());
		rc.setConversationTopic(msg.getConversationTopic());
		if (msg.getFrom()!=null)rc.setFrom(ExchEWSTranslator.convertEWSMailBox2MailAddress(msg.getFrom().getMailbox()));
		rc.setInternetMessageId(msg.getInternetMessageId());
		rc.setRead(msg.isIsRead());
		//rc.setResponseRequested(msg.isIsResponseRequested());
		//rc.setReferences(msg.getReferences());
		//ArrayOfRecipientsType replyTo = msg.getReplyTo();
		//if (replyTo!=null) rc.setReplyTo(ExchEWSTranslator.convertEWSArrayOfRecipientsType2MailBoxes(replyTo)[0]);
		if (msg.getReceivedBy()!=null)rc.setReceivedBy(ExchEWSTranslator.convertEWSMailBox2MailAddress(msg.getReceivedBy().getMailbox()));
		//if (msg.getReceivedRepresenting()!=null)rc.setReceivedRepresenting(ExchEWSTranslator.convertEWSMailBox2MailAddress(msg.getReceivedRepresenting().getMailbox()));
		ArrayOfRecipientsType re_ar = msg.getReplyTo();
		if (re_ar!=null) rc.setReplyTo(ExchEWSTranslator.convertEWSArrayOfRecipientsType2SingleMailAddress(re_ar));

		rc.setBeanData();
		return rc;
	}


	public static MessageType convertToMessageType(IMailDTO dto) throws Exception
	{
		MessageType rc = new MessageType();
		ExchewsMailDTO mail = null;
		if (dto instanceof BasicMailDTO) {
			mail = new ExchewsMailDTO(dto);
		}
		else if (dto instanceof ExchewsMailDTO) {
			mail = (ExchewsMailDTO)dto;
		}
		else {
			throw new IllegalArgumentException("dto must be instance of ExchewsMailDTO or BasicMailDto");
		}
		convertToItemType(rc, mail);
		
		MailAddress[] tos = dto.getTo();
		ArrayOfRecipientsType rArry = new ArrayOfRecipientsType();
		if (tos != null) {
			for (MailAddress to : tos) {
				rArry.getMailbox().add(ExchEWSTranslator.convertMailAddress2EWSMailBox(to));
			}
		}
		if (rArry.getMailbox().size()>0)rc.setToRecipients(rArry);
		
		MailAddress[] ccs = dto.getCC();
		rArry = new ArrayOfRecipientsType();
		if (ccs != null) {
			for (MailAddress cc : ccs) {
				rArry.getMailbox().add(ExchEWSTranslator.convertMailAddress2EWSMailBox(cc));
			}
		}
		if (rArry.getMailbox().size()>0)rc.setCcRecipients(rArry);
		
		MailAddress[] bccs = dto.getBCC();
		rArry = new ArrayOfRecipientsType();
		if (bccs != null) {
			for (MailAddress bcc : bccs) {
				rArry.getMailbox().add(ExchEWSTranslator.convertMailAddress2EWSMailBox(bcc));
			}
		}
		if (rArry.getMailbox().size()>0)rc.setBccRecipients(rArry);
		
		return rc;
	}
	
	@Override
	public AttachmentDTO getAttachment(int number)
	{
		return attachments[number];
	}

	@Override
	public AttachmentDTO[] getAttachments()
	{
		return attachments;
	}

	@Override
	public void setAttachments(AttachmentDTO[] attachments)
	{
		this.attachments = attachments;
	}

	@Override
	public MailAddress[] getBCC()
	{
		return this.bccRecipients;
	}

	@Override
	public MailAddress[] getCC()
	{
		return this.ccRecipients;
	}

	@Override
	public MailAddress getFrom()
	{
		return this.from;
	}

	@Override
	public String getMailBinary()
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public int getNumberOfAttachments()
	{
		if (this.attachments==null) return 0;
		return this.attachments.length;
	}

	@Override
	public int getPriority()
	{
		// TODO ꂽ\bhEX^u
		return 0;
	}

	@Override
	public Date getReceivedDate()
	{
		return this.dateTimeReceived;
	}

	@Override
	public MailAddress getReplyTo()
	{
		return this.replyTo;
	}

	@Override
	public Date getSentDate()
	{
		return this.dateTimeSent;
	}

	@Override
	public int getSize()
	{
		// TODO ꂽ\bhEX^u
		return 0;
	}

	@Override
	public MailAddress[] getTo()
	{
		return toRecipients;
	}

	@Override
	public void setBCC(MailAddress[] bcc)
	{
		this.bccRecipients = bcc;
	}

	@Override
	public void setCC(MailAddress[] cc)
	{
		// TODO ꂽ\bhEX^u
		this.ccRecipients = cc;
	}

	@Override
	public void setFrom(MailAddress from)
	{
		this.from = from;
	}

	@Override
	public void setPriority(int priority)
	{
		// TODO ꂽ\bhEX^u
	}

	@Override
	public void setReplyTo(MailAddress replyTo)
	{
		this.replyTo = replyTo;
		
	}

	@Override
	public void setSentDate(Date date)
	{
		this.dateTimeSent = date;
	}

	@Override
	public void setSize(int size)
	{
		// TODO ꂽ\bhEX^u
		
	}

	@Override
	public void setTo(MailAddress[] to)
	{
		this.toRecipients = to;
		
	}
}
