package jp.co.connectone.eai.exchews.log;

import org.apache.commons.logging.*;

public aspect LogAspect
{
	private org.apache.commons.logging.Log log = LogFactory.getLog(LogAspect.class);

	pointcut logdebug(String s) : call(void jp.co.connectone.log.Log.debug(..)) && args(s);
	void around(String s) : logdebug(s) {
		try {
			if (log.isDebugEnabled()) log.debug(s+"("+thisJoinPoint.getSourceLocation()+")");
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	pointcut logtrace(String s) : call(void jp.co.connectone.log.Log.trace(..)) && args(s);
	void around(String s) : logtrace(s) {
		try {
			if (log.isTraceEnabled()) log.trace(s+"("+thisJoinPoint.getSourceLocation()+")");
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
/*
  pointcut functionTrace() : call(* jp.co.connectone..*(..)) && !within(LogAspect) && !call(void jp.co.connectone.log.Log.*(..));
  before() : functionTrace() {
		if (log.isTraceEnabled()) log.trace(thisJoinPoint + "(" + thisJoinPoint.getSourceLocation() + ")");
  }
*/
}
