/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.ews;

import java.util.*;

import javax.xml.bind.JAXBElement;

import com.microsoft.schemas.exchange.services._2006.types.*;

import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.exception.*;
import jp.co.connectone.store.*;


/**
 * @author amanot
 *
 */
public class EWSSearchCondition implements ISearchCondition
{
	private String name;
	private UnindexedFieldURIType field;
	private Object value;
	private EWSSearchType type;
	private EWSSearchOperator operator;
	
	/**
	 * @return name ߂܂B
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name name ݒB
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return operator ߂܂B
	 */
	public EWSSearchOperator getOperator() {
		return operator;
	}
	/**
	 * @param operator operator ݒB
	 */
	public void setOperator(EWSSearchOperator operator) {
		this.operator = operator;
	}
	/**
	 * @return type ߂܂B
	 */
	public EWSSearchType getType() {
		return type;
	}

	/**
	 * @param type type ݒB
	 */
	public void setType(EWSSearchType type) {
		this.type = type;
	}
	/**
	 * @return value ߂܂B
	 */
	public Object getValue() {
		return value;
	}
	/**
	 * @param value value ݒB
	 */
	public void setValue(Object value) throws IllegalArgumentException
	{
		
		if (value!=null) {
			if(!(value instanceof String) && !(value instanceof Date)) {
				throw new IllegalArgumentException("value must be an instance of String/Date");
			}
		}
		this.value = value;
	}
	public EWSSearchCondition(String name,EWSSearchType type,Object value,EWSSearchOperator operator) throws IllegalArgumentException
	{
		setName(name);
		setType(type);
		setValue(value);
		setOperator(operator);
	}

	public EWSSearchCondition(UnindexedFieldURIType field,EWSSearchType type,Object value,EWSSearchOperator operator) throws IllegalArgumentException
	{
		setField(field);
		setType(type);
		setValue(value);
		setOperator(operator);
	}
	
	public JAXBElement<? extends SearchExpressionType> generateSearchExpression() throws HandleException
	{
		JAXBElement<? extends SearchExpressionType> exp = null;
		String strValue="";

		switch (type) {
		case TYPE_STRING:
			if (value instanceof String) strValue = (String)value;
			else throw new IncorrectData("value not maches with type.");
			break;
		case TYPE_INTEGER:
			if (value instanceof Integer) strValue = ((Integer)value).toString();
			else throw new IncorrectData("value not maches with type.");
			break;
		case TYPE_DATETIME_SZ:
			if (value instanceof Date) strValue = ExchEWSTranslator.javaDate2EWSDateStr((Date)value);
			else throw new IncorrectData("value not maches with type.");
			break;
		case TYPE_DATE_0000:
			if (value instanceof Date) strValue = ExchEWSTranslator.javaDate2EWSDateStr_DateTop((Date)value);
			else throw new IncorrectData("value not maches with type.");
			break;
		case TYPE_DATE_2359:
			if (value instanceof Date) strValue = ExchEWSTranslator.javaDate2EWSDateStr_DateEnd((Date)value);
			else throw new IncorrectData("value not maches with type.");
			break;
		}

		switch (operator) {
		case OP_EQUALS:
			exp = ExchEWSTranslator.createIsEqualTo(field,strValue);
			break;
		case OP_BIG_EQUAL:
			exp = ExchEWSTranslator.createIsGreaterThanOrEqualTo(field,strValue);
			break;
		case OP_SMALL_EQUAL:
			exp = ExchEWSTranslator.createIsLessThanOrEqualTo(field,strValue);
			break;
		case OP_CONTAINS:
//			exp = ExchEWSTranslator.createContains(field,strValue);
			break;
		}
		return exp;
	}

	public UnindexedFieldURIType getField()
	{
		return field;
	}

	public void setField(UnindexedFieldURIType field)
	{
		this.field = field;
	}
	
	
}
