/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exch2k.store;

import java.util.*;

import javax.mail.internet.MimeUtility;
import jp.co.connectone.store.pim.*;

/**
 * @author amanot
 *
 */
public class Exch2kMailDTO extends BasicMailDTO
{
/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/* urn:schemas:httpmail */
	protected String 	attachmentfilename;
	protected String 	bcc;
	protected String 	calendar;
	protected String 	cc;
	protected String 	contacts;
	protected String 	content_disposition_type;
	protected String 	content_media_type;
	protected Date 	date;
	protected Date 	datereceived;
	protected String 	deleteditems;
//X	protected String 	displaybcc; make 422 error
	protected String 	displaycc;
	protected String 	displayto;
	protected String 	drafts;
	protected Date 	expiry_date;
	protected Date 	flagcompleted;
	protected String 	from;
	protected String 	fromemail;
	protected String 	fromname;
	protected boolean hasattachment;
	protected String 	htmldescription;
	protected long 	importance;
	protected String	inbox;
	protected String	journal;
	protected String	messageflag;
	protected String	msgfolderroot;
	protected String	normalizedsubject;
	protected String	notes;
	protected String	outbox;
	protected long		priority;
	protected boolean	read;
	protected Date 	reply_by;
	protected String	reply_to;
	protected String	savedestination;
	protected boolean	saveinsent;
	protected String	sender;
	protected String	senderemail;
	protected String	sendername;
	protected String	sendmsg;
	protected String	sentitems;
	protected String	subject;
	protected boolean	submitted;
	protected String	tasks;
	protected String	textdescription;
	protected String	thread_topic;
	protected String	to;
	protected long		unreadcount;

/* override methods */
	public Exch2kMailDTO()
	{
		super();
	}
	/**
	 * @param header
	 */
	public Exch2kMailDTO(HeaderDTO header)
	{
		super(header);
		if (header != null){
			copyElements(header);
		}
	}
	
	/* ( Javadoc)
	 * @see jp.co.connectone.store.client.BasicMailDTO#setHeaderDTO(jp.co.connectone.store.client.HeaderDTO)
	 */
	public void setHeaderDTO(HeaderDTO header)
	{
		if (header != null){
			copyElements(header);
		}
		super.setHeaderDTO(header);
	}
	
/* original functions */
	public void copyExch2kElements2Header()
	{
		header.setHeaderFrom(from);
		header.setHeaderTo(parseAddresses(to));
		header.setHeaderCC(parseAddresses(cc));
		header.setHeaderBCC(parseAddresses(bcc));
		header.setHeaderReplyTo(reply_to);
		header.setHeaderSendDate(date);
		header.setHeaderSubject(subject);
		header.setHeaderPriority((int)importance);
	}
/* private functions */	
	private static final int TYPE_RAW=0;
	private static final int TYPE_NAME=1;
	private static final int TYPE_ADDRESS=2;


	private MailAddress[] parseAddresses(String src)
	{
		MailAddress[] ret = null;
		try {
			ret = MailAddress.parseAddressLine(MimeUtility.decodeText(src));
		}
		catch (Exception e) {};
		return ret;
	}
	private String addressArray2Line(MailAddress[] src,int type)
	{
		if (src==null) return null;
		String dst=",";
		for (int i=0;i<src.length;i++) {
			String add = "";
			switch(type) {
			case TYPE_RAW:
				add = src[i].getRawAddress();
				break;
			case TYPE_NAME:
				add = src[i].getRawAddress();
				break;
			case TYPE_ADDRESS:
				add = src[i].getRawAddress();
				break;
			}
			dst = dst + add + ",";
		}
		dst = dst.substring(0,dst.length()-1);
		return dst;
	}
	
	private void copyElements(HeaderDTO h)
	{
		bcc = addressArray2Line(h.getHeaderBCC(),TYPE_RAW);
		cc = addressArray2Line(h.getHeaderCC(),TYPE_RAW);
		date = h.getHeaderSendDate();
		
		displaycc = addressArray2Line(h.getHeaderCC(),TYPE_NAME);
		displayto = addressArray2Line(h.getHeaderTo(),TYPE_NAME);
		from = h.getHeaderFrom().getRawAddress();
		fromemail = h.getHeaderFrom().getAddressPart();
		fromname = h.getHeaderFrom().getNamePart();
		importance = h.getHeaderPriority();
		reply_to = h.getHeaderReplyTo().getRawAddress();
		subject = h.getHeaderSubject();
		to = addressArray2Line(h.getHeaderTo(),TYPE_RAW);
	}

/* getter/setter */
	public String getAttachmentfilename()
	{
		return attachmentfilename;
	}
	public void setAttachmentfilename(String attachmentfilename)
	{
		this.attachmentfilename = attachmentfilename;
	}
	public String getBcc()
	{
		return bcc;
	}
	public void setBcc(String bcc)
	{
		this.bcc = bcc;
	}
	public String getCalendar()
	{
		return calendar;
	}
	public void setCalendar(String calendar)
	{
		this.calendar = calendar;
	}
	public String getCc()
	{
		return cc;
	}
	public void setCc(String cc)
	{
		this.cc = cc;
	}
	public String getContacts()
	{
		return contacts;
	}
	public void setContacts(String contacts)
	{
		this.contacts = contacts;
	}
	public String getContent_disposition_type()
	{
		return content_disposition_type;
	}
	public void setContent_disposition_type(String content_disposition_type)
	{
		this.content_disposition_type = content_disposition_type;
	}
	public String getContent_media_type()
	{
		return content_media_type;
	}
	public void setContent_media_type(String content_media_type)
	{
		this.content_media_type = content_media_type;
	}
	public Date getDate()
	{
		return date;
	}
	public void setDate(Date date)
	{
		this.date = date;
	}
	public Date getDatereceived()
	{
		return datereceived;
	}
	public void setDatereceived(Date datereceived)
	{
		this.datereceived = datereceived;
	}
	public String getDeleteditems()
	{
		return deleteditems;
	}
	public void setDeleteditems(String deleteditems)
	{
		this.deleteditems = deleteditems;
	}
	public String getDisplaycc()
	{
		return displaycc;
	}
	public void setDisplaycc(String displaycc)
	{
		this.displaycc = displaycc;
	}
	public String getDisplayto()
	{
		return displayto;
	}
	public void setDisplayto(String displayto)
	{
		this.displayto = displayto;
	}
	public String getDrafts()
	{
		return drafts;
	}
	public void setDrafts(String drafts)
	{
		this.drafts = drafts;
	}
	public Date getExpiry_date()
	{
		return expiry_date;
	}
	public void setExpiry_date(Date expiry_date)
	{
		this.expiry_date = expiry_date;
	}
	public Date getFlagcompleted()
	{
		return flagcompleted;
	}
	public void setFlagcompleted(Date flagcompleted)
	{
		this.flagcompleted = flagcompleted;
	}
	public String getFromEx()
	{
		return from;
	}
	public void setFrom(String from)
	{
		this.from = from;
	}
	public String getFromname()
	{
		return fromname;
	}
	public void setFromname(String fromname)
	{
		this.fromname = fromname;
	}
	public String getFromemail()
	{
		return fromemail;
	}
	public void setFromemail(String fromemail)
	{
		this.fromemail = fromemail;
	}
	public boolean isHasattachment()
	{
		return hasattachment;
	}
	public void setHasattachment(boolean hasattachment)
	{
		this.hasattachment = hasattachment;
	}
	public String getHtmldescription()
	{
		return htmldescription;
	}
	public void setHtmldescription(String htmldescription)
	{
		this.htmldescription = htmldescription;
	}
	public long getImportance()
	{
		return importance;
	}
	public void setImportance(long importance)
	{
		this.importance = importance;
	}
	public String getInbox()
	{
		return inbox;
	}
	public void setInbox(String inbox)
	{
		this.inbox = inbox;
	}
	public String getJournal()
	{
		return journal;
	}
	public void setJournal(String journal)
	{
		this.journal = journal;
	}
	/**
	 * @return messageflag ߂܂B
	 */
	public String getMessageflag()
	{
		return messageflag;
	}
	/**
	 * @param messageflag ݒ肷 messageflagB
	 */
	public void setMessageflag(String messageflag)
	{
		this.messageflag = messageflag;
	}
	/**
	 * @return msgfolderroot ߂܂B
	 */
	public String getMsgfolderroot()
	{
		return msgfolderroot;
	}
	/**
	 * @param msgfolderroot ݒ肷 msgfolderrootB
	 */
	public void setMsgfolderroot(String msgfolderroot)
	{
		this.msgfolderroot = msgfolderroot;
	}
	/**
	 * @return normalizedsubject ߂܂B
	 */
	public String getNormalizedsubject()
	{
		return normalizedsubject;
	}
	/**
	 * @param normalizedsubject ݒ肷 normalizedsubjectB
	 */
	public void setNormalizedsubject(String normalizedsubject)
	{
		this.normalizedsubject = normalizedsubject;
	}
	/**
	 * @return notes ߂܂B
	 */
	public String getNotes()
	{
		return notes;
	}
	/**
	 * @param notes ݒ肷 notesB
	 */
	public void setNotes(String notes)
	{
		this.notes = notes;
	}
	/**
	 * @return outbox ߂܂B
	 */
	public String getOutbox()
	{
		return outbox;
	}
	/**
	 * @param outbox ݒ肷 outboxB
	 */
	public void setOutbox(String outbox)
	{
		this.outbox = outbox;
	}
	/**
	 * @return priority ߂܂B
	 */
	public long getPriorityEx()
	{
		return priority;
	}
	/**
	 * @param priority ݒ肷 priorityB
	 */
	public void setPriority(long priority)
	{
		this.priority = priority;
	}
	/**
	 * @return read ߂܂B
	 */
	public boolean isRead()
	{
		return read;
	}
	/**
	 * @param read ݒ肷 readB
	 */
	public void setRead(boolean read)
	{
		this.read = read;
	}
	/**
	 * @return reply_by ߂܂B
	 */
	public Date getReply_by()
	{
		return reply_by;
	}
	/**
	 * @param reply_by ݒ肷 reply_byB
	 */
	public void setReply_by(Date reply_by)
	{
		this.reply_by = reply_by;
	}
	/**
	 * @return reply_to ߂܂B
	 */
	public String getReply_to()
	{
		return reply_to;
	}
	/**
	 * @param reply_to ݒ肷 reply_toB
	 */
	public void setReply_to(String reply_to)
	{
		this.reply_to = reply_to;
	}
	/**
	 * @return savedestination ߂܂B
	 */
	public String getSavedestination()
	{
		return savedestination;
	}
	/**
	 * @param savedestination ݒ肷 savedestinationB
	 */
	public void setSavedestination(String savedestination)
	{
		this.savedestination = savedestination;
	}
	/**
	 * @return saveinsent ߂܂B
	 */
	public boolean isSaveinsent()
	{
		return saveinsent;
	}
	/**
	 * @param saveinsent ݒ肷 saveinsentB
	 */
	public void setSaveinsent(boolean saveinsent)
	{
		this.saveinsent = saveinsent;
	}
	/**
	 * @return sender ߂܂B
	 */
	public String getSender()
	{
		return sender;
	}
	/**
	 * @param sender ݒ肷 senderB
	 */
	public void setSender(String sender)
	{
		this.sender = sender;
	}
	/**
	 * @return senderemail ߂܂B
	 */
	public String getSenderemail()
	{
		return senderemail;
	}
	/**
	 * @param senderemail ݒ肷 senderemailB
	 */
	public void setSenderemail(String senderemail)
	{
		this.senderemail = senderemail;
	}
	/**
	 * @return sendername ߂܂B
	 */
	public String getSendername()
	{
		return sendername;
	}
	/**
	 * @param sendername ݒ肷 sendernameB
	 */
	public void setSendername(String sendername)
	{
		this.sendername = sendername;
	}
	/**
	 * @return sendmsg ߂܂B
	 */
	public String getSendmsg()
	{
		return sendmsg;
	}
	/**
	 * @param sendmsg ݒ肷 sendmsgB
	 */
	public void setSendmsg(String sendmsg)
	{
		this.sendmsg = sendmsg;
	}
	/**
	 * @return sentitems ߂܂B
	 */
	public String getSentitems()
	{
		return sentitems;
	}
	/**
	 * @param sentitems ݒ肷 sentitemsB
	 */
	public void setSentitems(String sentitems)
	{
		this.sentitems = sentitems;
	}
	/**
	 * @return submitted ߂܂B
	 */
	public boolean isSubmitted()
	{
		return submitted;
	}
	/**
	 * @param submitted ݒ肷 submittedB
	 */
	public void setSubmitted(boolean submitted)
	{
		this.submitted = submitted;
	}
	/**
	 * @return tasks ߂܂B
	 */
	public String getTasks()
	{
		return tasks;
	}
	/**
	 * @param tasks ݒ肷 tasksB
	 */
	public void setTasks(String tasks)
	{
		this.tasks = tasks;
	}
	/**
	 * @return textdescription ߂܂B
	 */
	public String getTextdescription()
	{
		return textdescription;
	}
	/**
	 * @param textdescription ݒ肷 textdescriptionB
	 */
	public void setTextdescription(String textdescription)
	{
		this.textdescription = textdescription;
	}
	/**
	 * @return thread_topic ߂܂B
	 */
	public String getThread_topic()
	{
		return thread_topic;
	}
	/**
	 * @param thread_topic ݒ肷 thread_topicB
	 */
	public void setThread_topic(String thread_topic)
	{
		this.thread_topic = thread_topic;
	}
	/**
	 * @return to ߂܂B
	 */
	public String getToEx()
	{
		return to;
	}
	/**
	 * @param to ݒ肷 toB
	 */
	public void setTo(String to)
	{
		this.to = to;
	}
	/**
	 * @return unreadcount ߂܂B
	 */
	public long getUnreadcount()
	{
		return unreadcount;
	}
	/**
	 * @param unreadcount ݒ肷 unreadcountB
	 */
	public void setUnreadcount(long unreadcount)
	{
		this.unreadcount = unreadcount;
	}
	/**
	 * @return subject ߂܂B
	 */
	public String getSubject()
	{
		return subject;
	}
	/**
	 * @param subject ݒ肷 subjectB
	 */
	public void setSubject(String subject)
	{
		this.subject = subject;
	}
	
	
}
